/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class TemplateCallGraph {
    private final Multimap<TemplateNode, TemplateNode> callers = Multimaps.newSetMultimap((Map)Maps.newLinkedHashMap(), (Supplier)new Supplier<Set<TemplateNode>>(){

        public Set<TemplateNode> get() {
            return Sets.newLinkedHashSet();
        }
    });

    TemplateCallGraph(final Map<String, ImmutableList<TemplateNode>> map) {
        for (ImmutableList<TemplateNode> immutableList : map.values()) {
            for (final TemplateNode templateNode : immutableList) {
                class CallGraphBuilder
                extends AbstractSoyNodeVisitor<Void> {
                    CallGraphBuilder() {
                    }

                    @Override
                    public void visitCallBasicNode(CallBasicNode callBasicNode) {
                        ImmutableList immutableList = (ImmutableList)map.get(callBasicNode.getCalleeName());
                        if (immutableList != null) {
                            for (TemplateNode templateNode2 : immutableList) {
                                TemplateCallGraph.this.callers.put((Object)templateNode2, (Object)templateNode);
                            }
                        }
                    }

                    @Override
                    protected void visitSoyNode(SoyNode soyNode) {
                        if (soyNode instanceof SoyNode.ParentSoyNode) {
                            this.visitChildren((SoyNode.ParentSoyNode)soyNode);
                        }
                    }
                }
                new CallGraphBuilder().exec(templateNode);
            }
        }
    }

    Set<TemplateNode> callersOf(Iterable<TemplateNode> iterable) {
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (TemplateNode templateNode : iterable) {
            this.addTransitively(templateNode, linkedHashSet);
        }
        return linkedHashSet;
    }

    private void addTransitively(TemplateNode templateNode, Set<? super TemplateNode> set) {
        for (TemplateNode templateNode2 : this.callers.get((Object)templateNode)) {
            if (!set.add(templateNode2)) continue;
            this.addTransitively(templateNode2, set);
        }
    }
}

