/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.restricted;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.internal.base.Escaper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class EscapingConventions {
    public static final String INNOCUOUS_OUTPUT = "zSoyz";
    public static final Pattern HTML_TAG_CONTENT = Pattern.compile("<(?:!|/?[a-zA-Z])(?:[^>'\"]|\"[^\"]*\"|'[^']*')*>");

    public static Iterable<CrossLanguageStringXform> getAllEscapers() {
        return ImmutableList.of((Object)EscapeHtml.INSTANCE, (Object)NormalizeHtml.INSTANCE, (Object)EscapeHtmlNospace.INSTANCE, (Object)NormalizeHtmlNospace.INSTANCE, (Object)EscapeJsString.INSTANCE, (Object)EscapeJsRegex.INSTANCE, (Object)EscapeCssString.INSTANCE, (Object)FilterCssValue.INSTANCE, (Object)EscapeUri.INSTANCE, (Object)NormalizeUri.INSTANCE, (Object)FilterNormalizeUri.INSTANCE, (Object)FilterHtmlAttribute.INSTANCE, (Object[])new CrossLanguageStringXform[]{FilterHtmlElementName.INSTANCE});
    }

    private static String toFullWidth(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0080') continue;
            stringBuilder.setCharAt(i, (char)(c + 65280 - 32));
        }
        return stringBuilder.toString();
    }

    public static final class FilterHtmlElementName
    extends CrossLanguageStringXform {
        public static final FilterHtmlElementName INSTANCE = new FilterHtmlElementName();

        private FilterHtmlElementName() {
            super(Pattern.compile("^(?!script|style|title|textarea|xmp|no)[a-z0-9_$:-]*\\z", 2), (List<? extends String>)ImmutableList.of(), null);
        }

        @Override
        protected ImmutableList<Escape> defineEscapes() {
            return ImmutableList.of();
        }
    }

    public static final class FilterHtmlAttribute
    extends CrossLanguageStringXform {
        public static final FilterHtmlAttribute INSTANCE = new FilterHtmlAttribute();

        private FilterHtmlAttribute() {
            super(Pattern.compile("^(?!style|on|action|archive|background|cite|classid|codebase|data|dsync|href|longdesc|src|usemap)(?:[a-z0-9_$:-]*)\\z", 2), (List<? extends String>)ImmutableList.of(), null);
        }

        @Override
        protected ImmutableList<Escape> defineEscapes() {
            return ImmutableList.of();
        }
    }

    public static final class EscapeUri
    extends CrossLanguageStringXform {
        public static final EscapeUri INSTANCE = new EscapeUri();

        private EscapeUri() {
            super(null, (List<? extends String>)ImmutableList.of((Object)"goog.string.urlEncode", (Object)"encodeURIComponent"), "%");
        }

        @Override
        protected ImmutableList<Escape> defineEscapes() {
            return new UriEscapeListBuilder().escapeAllInRangeExcept(0, 128, '-', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '~').build();
        }
    }

    public static final class FilterNormalizeUri
    extends CrossLanguageStringXform {
        public static final FilterNormalizeUri INSTANCE = new FilterNormalizeUri();

        private FilterNormalizeUri() {
            super(Pattern.compile("^(?:(?:https?|mailto):|[^&:\\/?#]*(?:[\\/?#]|\\z))", 2), (List<? extends String>)ImmutableList.of(), null);
        }

        @Override
        protected ImmutableList<Escape> defineEscapes() {
            return NormalizeUri.INSTANCE.defineEscapes();
        }
    }

    public static final class NormalizeUri
    extends CrossLanguageStringXform {
        public static final NormalizeUri INSTANCE = new NormalizeUri();

        private NormalizeUri() {
            super(null, (List<? extends String>)ImmutableList.of(), null);
        }

        @Override
        protected ImmutableList<Escape> defineEscapes() {
            return new UriEscapeListBuilder().escapeAll("\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007").escapeAll("\b\t\n\u000b\f\r\u000e\u000f").escapeAll("\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017").escapeAll("\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f").escape('\u007f').escapeAll(" (){}\"'\\<>").escapeAll("\u0085\u00a0\u2028\u2029").escapeAll(EscapingConventions.toFullWidth(":/?#[]@!$&'()*+,;=")).build();
        }
    }

    private static final class UriEscapeListBuilder
    extends EscapeListBuilder {
        private UriEscapeListBuilder() {
        }

        @Override
        String getNumericEscapeFor(char c) {
            byte[] byArray = Character.toString(c).getBytes(Charsets.UTF_8);
            int n = byArray.length;
            StringBuilder stringBuilder = new StringBuilder(n * 3);
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(String.format("%%%02X", byArray[i]));
            }
            return stringBuilder.toString();
        }
    }

    public static final class FilterCssValue
    extends CrossLanguageStringXform {
        public static final Pattern CSS_WORD = Pattern.compile("^(?!-*(?:expression|(?:moz-)?binding))(?:[.#]?-?(?:[_a-z0-9-]+)(?:-[_a-z0-9-]+)*-?|-?(?:[0-9]+(?:\\.[0-9]*)?|\\.[0-9]+)(?:[a-z]{1,2}|%)?|!important|)\\z", 2);
        public static final FilterCssValue INSTANCE = new FilterCssValue();

        private FilterCssValue() {
            super(CSS_WORD, (List<? extends String>)ImmutableList.of(), null);
        }

        @Override
        protected ImmutableList<Escape> defineEscapes() {
            return ImmutableList.of();
        }
    }

    public static final class EscapeCssString
    extends CrossLanguageStringXform {
        public static final EscapeCssString INSTANCE = new EscapeCssString();

        private EscapeCssString() {
            super(null, (List<? extends String>)ImmutableList.of(), null);
        }

        @Override
        protected ImmutableList<Escape> defineEscapes() {
            return new CssEscapeListBuilder().escapeAll("\u0000\b\t\n\u000b\f\r\u0085\u00a0\u2028\u2029\"'\\<>&{};:()@/=*").build();
        }
    }

    private static final class CssEscapeListBuilder
    extends EscapeListBuilder {
        private CssEscapeListBuilder() {
        }

        @Override
        String getNumericEscapeFor(char c) {
            return String.format("\\%x ", c);
        }
    }

    public static final class EscapeJsRegex
    extends CrossLanguageStringXform {
        public static final EscapeJsRegex INSTANCE = new EscapeJsRegex();

        private EscapeJsRegex() {
            super(null, (List<? extends String>)ImmutableList.of(), null);
        }

        @Override
        protected ImmutableList<Escape> defineEscapes() {
            return new JsEscapeListBuilder().escape('\u0000').escape('\b').escape('\t', "\\t").escape('\n', "\\n").escape('\u000b').escape('\f', "\\f").escape('\r', "\\r").escape('\\', "\\\\").escapeAll("\u2028\u2029").escape('\u0085').escape('\"').escape('\'').escape('/', "\\/").escapeAll("<>&=").escapeAll("$()*+-.:?[]^{|},").build();
        }
    }

    public static final class EscapeJsString
    extends CrossLanguageStringXform {
        public static final EscapeJsString INSTANCE = new EscapeJsString();

        private EscapeJsString() {
            super(null, (List<? extends String>)ImmutableList.of(), null);
        }

        @Override
        protected ImmutableList<Escape> defineEscapes() {
            return new JsEscapeListBuilder().escape('\u0000').escape('\b').escape('\t', "\\t").escape('\n', "\\n").escape('\u000b').escape('\f', "\\f").escape('\r', "\\r").escape('\\', "\\\\").escape('\"').escape('\'').escape('/', "\\/").escapeAll("\u2028\u2029").escape('\u0085').escapeAll("<>&=").build();
        }
    }

    private static final class JsEscapeListBuilder
    extends EscapeListBuilder {
        private JsEscapeListBuilder() {
        }

        @Override
        String getNumericEscapeFor(char c) {
            return String.format(c < '\u0100' ? "\\x%02x" : "\\u%04x", c);
        }
    }

    public static final class NormalizeHtmlNospace
    extends CrossLanguageStringXform {
        public static final NormalizeHtmlNospace INSTANCE = new NormalizeHtmlNospace();

        private NormalizeHtmlNospace() {
            super(null, (List<? extends String>)ImmutableList.of(), null);
        }

        @Override
        protected ImmutableList<Escape> defineEscapes() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Escape escape : EscapeHtmlNospace.INSTANCE.getEscapes()) {
                if (escape.plainText == '&') continue;
                builder.add((Object)escape);
            }
            return builder.build();
        }
    }

    public static final class EscapeHtmlNospace
    extends CrossLanguageStringXform {
        public static final EscapeHtmlNospace INSTANCE = new EscapeHtmlNospace();

        private EscapeHtmlNospace() {
            super(null, (List<? extends String>)ImmutableList.of(), null);
        }

        @Override
        protected ImmutableList<Escape> defineEscapes() {
            return new HtmlEscapeListBuilder().escape('&', "&amp;").escape('<', "&lt;").escape('>', "&gt;").escape('\"', "&quot;").escapeAll("\u0000\t\n\u000b\f\r '-/=`\u0085\u00a0\u2028\u2029").build();
        }
    }

    public static final class NormalizeHtml
    extends CrossLanguageStringXform {
        public static final NormalizeHtml INSTANCE = new NormalizeHtml();

        private NormalizeHtml() {
            super(null, (List<? extends String>)ImmutableList.of(), null);
        }

        @Override
        protected ImmutableList<Escape> defineEscapes() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Escape escape : EscapeHtml.INSTANCE.getEscapes()) {
                if (escape.plainText == '&') continue;
                builder.add((Object)escape);
            }
            return builder.build();
        }
    }

    public static final class EscapeHtml
    extends CrossLanguageStringXform {
        public static final EscapeHtml INSTANCE = new EscapeHtml();

        private EscapeHtml() {
            super(null, (List<? extends String>)ImmutableList.of(), null);
        }

        @Override
        protected ImmutableList<Escape> defineEscapes() {
            return new HtmlEscapeListBuilder().escape('&', "&amp;").escape('<', "&lt;").escape('>', "&gt;").escape('\"', "&quot;").escapeAll("\u0000'").build();
        }
    }

    private static final class HtmlEscapeListBuilder
    extends EscapeListBuilder {
        private HtmlEscapeListBuilder() {
        }

        @Override
        String getNumericEscapeFor(char c) {
            return "&#" + c + ";";
        }
    }

    private static abstract class EscapeListBuilder {
        private final List<Escape> escapes = Lists.newArrayList();

        private EscapeListBuilder() {
        }

        abstract String getNumericEscapeFor(char var1);

        final EscapeListBuilder escape(char c, String string) {
            this.escapes.add(new Escape(c, string));
            return this;
        }

        final EscapeListBuilder escape(char c) {
            this.escapes.add(new Escape(c, this.getNumericEscapeFor(c)));
            return this;
        }

        final EscapeListBuilder escapeAll(String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                this.escape(string.charAt(i));
            }
            return this;
        }

        final EscapeListBuilder escapeAllInRangeExcept(int n, int n2, char ... cArray) {
            cArray = (char[])cArray.clone();
            Arrays.sort(cArray);
            int n3 = 0;
            int n4 = cArray.length;
            for (int i = n; i < n2; ++i) {
                while (n3 < n4 && cArray[n3] < i) {
                    ++n3;
                }
                if (n3 < n4 && cArray[n3] == i) continue;
                this.escape((char)i);
            }
            return this;
        }

        final ImmutableList<Escape> build() {
            Collections.sort(this.escapes);
            return ImmutableList.copyOf(this.escapes);
        }
    }

    public static abstract class CrossLanguageStringXform
    implements Escaper {
        private final String directiveName;
        @Nullable
        private final Pattern valueFilter;
        @Nullable
        private final List<String> jsNames;
        private final ImmutableList<Escape> escapes;
        private final String[] escapesByCodeUnit;
        private final char[] nonAsciiCodeUnits;
        private final String[] nonAsciiEscapes;
        @Nullable
        private final String nonAsciiPrefix;
        private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        protected CrossLanguageStringXform(@Nullable Pattern pattern, List<? extends String> list, @Nullable String string) {
            int n;
            String string2 = this.getClass().getSimpleName();
            this.directiveName = "|" + Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
            this.valueFilter = pattern;
            this.jsNames = ImmutableList.copyOf(list);
            this.escapes = this.defineEscapes();
            int n2 = this.escapes.size();
            for (n = this.escapes.size(); n > 0 && ((Escape)this.escapes.get(n - 1)).plainText >= '\u0080'; --n) {
            }
            if (n != 0) {
                this.escapesByCodeUnit = new String[((Escape)this.escapes.get(n - 1)).plainText + '\u0001'];
                for (Escape escape : this.escapes.subList(0, n)) {
                    this.escapesByCodeUnit[((Escape)escape).plainText] = escape.escaped;
                }
            } else {
                this.escapesByCodeUnit = new String[0];
            }
            if (n2 != n) {
                int n3 = n2 - n;
                this.nonAsciiCodeUnits = new char[n3];
                this.nonAsciiEscapes = new String[n3];
                for (int i = 0; i < n3; ++i) {
                    Escape escape = (Escape)this.escapes.get(n + i);
                    this.nonAsciiCodeUnits[i] = escape.plainText;
                    this.nonAsciiEscapes[i] = escape.escaped;
                }
            } else {
                this.nonAsciiCodeUnits = new char[0];
                this.nonAsciiEscapes = new String[0];
            }
            this.nonAsciiPrefix = string;
        }

        protected abstract ImmutableList<Escape> defineEscapes();

        public String getDirectiveName() {
            return this.directiveName;
        }

        @Nullable
        public final String getNonAsciiPrefix() {
            return this.nonAsciiPrefix;
        }

        @Nullable
        public final Pattern getValueFilter() {
            return this.valueFilter;
        }

        public final List<String> getJsFunctionNames() {
            return this.jsNames;
        }

        public final ImmutableList<Escape> getEscapes() {
            return this.escapes;
        }

        @Override
        public final String escape(String string) {
            StringBuilder stringBuilder = this.maybeEscapeOnto(string, null);
            return stringBuilder != null ? stringBuilder.toString() : string;
        }

        @Override
        public final Appendable escape(final Appendable appendable) {
            return new Appendable(){

                @Override
                public Appendable append(CharSequence charSequence) throws IOException {
                    CrossLanguageStringXform.this.maybeEscapeOnto(charSequence, appendable, 0, charSequence.length());
                    return this;
                }

                @Override
                public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
                    CrossLanguageStringXform.this.maybeEscapeOnto(charSequence, appendable, n, n2);
                    return this;
                }

                @Override
                public Appendable append(char c) throws IOException {
                    if (c < CrossLanguageStringXform.this.escapesByCodeUnit.length) {
                        String string = CrossLanguageStringXform.this.escapesByCodeUnit[c];
                        if (string != null) {
                            appendable.append(string);
                            return this;
                        }
                    } else if (c >= '\u0080') {
                        int n = Arrays.binarySearch(CrossLanguageStringXform.this.nonAsciiCodeUnits, c);
                        if (n >= 0) {
                            appendable.append(CrossLanguageStringXform.this.nonAsciiEscapes[n]);
                            return this;
                        }
                        if (CrossLanguageStringXform.this.nonAsciiPrefix != null) {
                            CrossLanguageStringXform.this.escapeUsingPrefix(c, appendable);
                            return this;
                        }
                    }
                    appendable.append(c);
                    return this;
                }
            };
        }

        @Nullable
        private StringBuilder maybeEscapeOnto(CharSequence charSequence, @Nullable StringBuilder stringBuilder) {
            try {
                return (StringBuilder)this.maybeEscapeOnto(charSequence, stringBuilder, 0, charSequence.length());
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Nullable
        private Appendable maybeEscapeOnto(CharSequence charSequence, @Nullable Appendable appendable, int n, int n2) throws IOException {
            int n3 = n;
            for (int i = n; i < n2; ++i) {
                char c = charSequence.charAt(i);
                if (c < this.escapesByCodeUnit.length) {
                    String string = this.escapesByCodeUnit[c];
                    if (string == null) continue;
                    if (appendable == null) {
                        appendable = new StringBuilder(n2 - n + 32);
                    }
                    appendable.append(charSequence, n3, i).append(string);
                    n3 = i + 1;
                    continue;
                }
                if (c < '\u0080') continue;
                int n4 = Arrays.binarySearch(this.nonAsciiCodeUnits, c);
                if (n4 >= 0) {
                    if (appendable == null) {
                        appendable = new StringBuilder(n2 - n + 32);
                    }
                    appendable.append(charSequence, n3, i).append(this.nonAsciiEscapes[n4]);
                    n3 = i + 1;
                    continue;
                }
                if (this.nonAsciiPrefix == null) continue;
                if (appendable == null) {
                    appendable = new StringBuilder(n2 - n + 32);
                }
                appendable.append(charSequence, n3, i);
                this.escapeUsingPrefix(c, appendable);
                n3 = i + 1;
            }
            if (appendable != null) {
                appendable.append(charSequence, n3, n2);
            }
            return appendable;
        }

        private void escapeUsingPrefix(char c, Appendable appendable) throws IOException {
            if ("%".equals(this.nonAsciiPrefix)) {
                if (c < '\u0800') {
                    appendable.append('%');
                    this.appendHexPair(c >>> 6 & 0x1F | 0xC0, appendable);
                } else {
                    appendable.append('%');
                    this.appendHexPair(c >>> 12 & 0xF | 0xE0, appendable);
                    appendable.append('%');
                    this.appendHexPair(c >>> 6 & 0x3F | 0x80, appendable);
                }
                appendable.append('%');
                this.appendHexPair(c & 0x3F | 0x80, appendable);
            } else {
                appendable.append(this.nonAsciiPrefix);
                this.appendHexPair(c >>> 8 & 0xFF, appendable);
                this.appendHexPair(c & 0xFF, appendable);
                if ("\\".equals(this.nonAsciiPrefix)) {
                    appendable.append(' ');
                }
            }
        }

        private void appendHexPair(int n, Appendable appendable) throws IOException {
            appendable.append(HEX_DIGITS[n >>> 4]);
            appendable.append(HEX_DIGITS[n & 0xF]);
        }
    }

    public static final class Escape
    implements Comparable<Escape> {
        private final char plainText;
        private final String escaped;

        public Escape(char c, String string) {
            this.plainText = c;
            this.escaped = string;
        }

        public char getPlainText() {
            return this.plainText;
        }

        public String getEscaped() {
            return this.escaped;
        }

        @Override
        public int compareTo(Escape escape) {
            return this.plainText - escape.plainText;
        }
    }
}

