/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.collect.Lists;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.List;

public class CombineConsecutiveRawTextNodesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private IdGenerator nodeIdGen;

    @Override
    public Void exec(SoyNode soyNode) {
        this.nodeIdGen = soyNode.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator();
        return (Void)super.exec(soyNode);
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)soyNode);
        }
        if (!(soyNode instanceof SoyNode.BlockNode)) {
            return;
        }
        SoyNode.BlockNode blockNode = (SoyNode.BlockNode)soyNode;
        boolean bl = false;
        for (int i = 0; i <= blockNode.numChildren() - 2; ++i) {
            if (!(blockNode.getChild(i) instanceof RawTextNode) || !(blockNode.getChild(i + 1) instanceof RawTextNode)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        ArrayList arrayList = Lists.newArrayList(blockNode.getChildren());
        blockNode.clearChildren();
        ArrayList arrayList2 = Lists.newArrayList();
        for (SoyNode.StandaloneNode standaloneNode : arrayList) {
            if (standaloneNode instanceof RawTextNode) {
                arrayList2.add((RawTextNode)standaloneNode);
                continue;
            }
            this.addConsecutiveRawTextNodesAsOneNodeHelper(blockNode, arrayList2);
            arrayList2.clear();
            blockNode.addChild(standaloneNode);
        }
        this.addConsecutiveRawTextNodesAsOneNodeHelper(blockNode, arrayList2);
        arrayList2.clear();
    }

    private void addConsecutiveRawTextNodesAsOneNodeHelper(SoyNode.BlockNode blockNode, List<RawTextNode> list) {
        if (list.size() == 0) {
            return;
        }
        if (list.size() == 1) {
            blockNode.addChild((Node)list.get(0));
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (RawTextNode rawTextNode : list) {
                stringBuilder.append(rawTextNode.getRawText());
            }
            blockNode.addChild(new RawTextNode(this.nodeIdGen.genId(), stringBuilder.toString()));
        }
    }
}

