/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.template.soy.sharedpasses.FindUsedIjParamsInExprHelperVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class FindUsedIjParamsVisitor
extends AbstractSoyNodeVisitor<UsedIjParamsInfo> {
    private TemplateRegistry templateRegistry;
    private Set<TemplateNode> visitedTemplates;
    private TemplateNode currTemplate;
    private Deque<TemplateNode> callerStack;
    private Multimap<String, TemplateNode> usedIjParamToCalleesMultimap;
    private boolean mayHaveExternalUsedIjParams;

    public FindUsedIjParamsVisitor(@Nullable TemplateRegistry templateRegistry) {
        this.templateRegistry = templateRegistry;
    }

    @Override
    public UsedIjParamsInfo exec(SoyNode soyNode) {
        this.visitedTemplates = Sets.newHashSet();
        this.currTemplate = null;
        this.callerStack = new ArrayDeque<TemplateNode>();
        this.usedIjParamToCalleesMultimap = LinkedHashMultimap.create();
        this.mayHaveExternalUsedIjParams = false;
        this.visit(soyNode);
        return new UsedIjParamsInfo(this.usedIjParamToCalleesMultimap, this.mayHaveExternalUsedIjParams);
    }

    @Override
    protected void visitTemplateNode(TemplateNode templateNode) {
        Object object;
        if (this.templateRegistry == null) {
            object = (SoyFileSetNode)templateNode.getParent().getParent();
            this.templateRegistry = new TemplateRegistry((SoyFileSetNode)object);
        }
        this.visitedTemplates.add(templateNode);
        object = new FindUsedIjParamsInExprHelperVisitor();
        SoytreeUtils.execOnAllV2Exprs(templateNode, object);
        Set<String> set = ((FindUsedIjParamsInExprHelperVisitor)object).getResult();
        for (String string : set) {
            this.usedIjParamToCalleesMultimap.put((Object)string, (Object)templateNode);
        }
        this.currTemplate = templateNode;
        this.visitChildren(templateNode);
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode callBasicNode) {
        this.visitChildren(callBasicNode);
        TemplateBasicNode templateBasicNode = this.templateRegistry.getBasicTemplate(callBasicNode.getCalleeName());
        if (templateBasicNode == null) {
            this.mayHaveExternalUsedIjParams = true;
            return;
        }
        this.visitCalleeHelper(templateBasicNode);
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode callDelegateNode) {
        this.visitChildren(callDelegateNode);
        this.mayHaveExternalUsedIjParams = true;
        List<TemplateRegistry.DelegateTemplateDivision> list = this.templateRegistry.getSortedDelegateTemplateDivisions(callDelegateNode.getDelCalleeName());
        if (list != null) {
            for (TemplateRegistry.DelegateTemplateDivision delegateTemplateDivision : list) {
                for (TemplateDelegateNode templateDelegateNode : delegateTemplateDivision.delPackageNameToDelTemplateMap.values()) {
                    this.visitCalleeHelper(templateDelegateNode);
                }
            }
        }
    }

    private void visitCalleeHelper(TemplateNode templateNode) {
        if (templateNode == this.currTemplate || this.callerStack.contains(templateNode)) {
            return;
        }
        if (this.visitedTemplates.contains(templateNode)) {
            return;
        }
        this.callerStack.push(this.currTemplate);
        this.visit(templateNode);
        this.currTemplate = this.callerStack.pop();
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)soyNode);
        }
    }

    public static class UsedIjParamsInfo {
        public final Multimap<String, TemplateNode> usedIjParamToCalleesMultimap;
        public final boolean mayHaveExternalUsedIjParams;

        public UsedIjParamsInfo(Multimap<String, TemplateNode> multimap, boolean bl) {
            this.usedIjParamToCalleesMultimap = multimap;
            this.mayHaveExternalUsedIjParams = bl;
        }
    }
}

