/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

public class MarkLocalVarDataRefsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private Deque<Set<String>> localVarFrames;
    private MarkLocalVarDataRefsInExprVisitor markLocalVarDataRefsInExprVisitor;

    @Override
    public Void exec(SoyNode soyNode) {
        Preconditions.checkArgument((soyNode instanceof SoyFileSetNode || soyNode instanceof SoyFileNode || soyNode instanceof TemplateNode ? 1 : 0) != 0);
        return (Void)super.exec(soyNode);
    }

    @Override
    protected void visitTemplateNode(TemplateNode templateNode) {
        this.localVarFrames = new ArrayDeque<Set<String>>();
        this.markLocalVarDataRefsInExprVisitor = new MarkLocalVarDataRefsInExprVisitor(this.localVarFrames);
        this.visitSoyNode(templateNode);
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ExprHolderNode) {
            this.visitExprHolderHelper((SoyNode.ExprHolderNode)soyNode);
        }
        if (soyNode instanceof SoyNode.LocalVarInlineNode) {
            this.localVarFrames.peek().add(((SoyNode.LocalVarInlineNode)soyNode).getVarName());
        }
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            if (soyNode instanceof SoyNode.LocalVarBlockNode) {
                SoyNode.LocalVarBlockNode localVarBlockNode = (SoyNode.LocalVarBlockNode)soyNode;
                HashSet hashSet = Sets.newHashSet();
                hashSet.add(localVarBlockNode.getVarName());
                this.localVarFrames.push(hashSet);
                this.visitChildren(localVarBlockNode);
                this.localVarFrames.pop();
            } else if (soyNode instanceof SoyNode.BlockNode) {
                this.localVarFrames.push(Sets.newHashSet());
                this.visitChildren((SoyNode.BlockNode)soyNode);
                this.localVarFrames.pop();
            } else {
                this.visitChildren((SoyNode.ParentSoyNode)soyNode);
            }
        }
    }

    private void visitExprHolderHelper(SoyNode.ExprHolderNode exprHolderNode) {
        for (ExprUnion exprUnion : exprHolderNode.getAllExprUnions()) {
            if (exprUnion.getExpr() == null) continue;
            this.markLocalVarDataRefsInExprVisitor.exec(exprUnion.getExpr());
        }
    }

    private static class MarkLocalVarDataRefsInExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final Deque<Set<String>> localVarFrames;

        public MarkLocalVarDataRefsInExprVisitor(Deque<Set<String>> deque) {
            this.localVarFrames = deque;
        }

        @Override
        protected void visitDataRefNode(DataRefNode dataRefNode) {
            boolean bl;
            if (dataRefNode.isIjDataRef()) {
                bl = false;
            } else {
                String string = dataRefNode.getFirstKey();
                bl = false;
                for (Set<String> set : this.localVarFrames) {
                    if (!set.contains(string)) continue;
                    bl = true;
                    break;
                }
            }
            dataRefNode.setIsLocalVarDataRef(bl);
            this.visitChildren(dataRefNode);
        }

        @Override
        protected void visitExprNode(ExprNode exprNode) {
            if (exprNode instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)exprNode);
            }
        }
    }
}

