/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.annotations.VisibleForTesting;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.internalutils.DataUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoytreeUtils;
import java.util.Map;
import javax.annotation.Nullable;

public class SubstituteGlobalsVisitor {
    private Map<String, PrimitiveData> compileTimeGlobals;
    private final boolean shouldAssertNoUnboundGlobals;

    public SubstituteGlobalsVisitor(@Nullable Map<String, PrimitiveData> map, boolean bl) {
        this.compileTimeGlobals = map;
        this.shouldAssertNoUnboundGlobals = bl;
    }

    public void exec(SoyFileSetNode soyFileSetNode) {
        SoytreeUtils.execOnAllV2Exprs(soyFileSetNode, new SubstituteGlobalsInExprVisitor());
    }

    @VisibleForTesting
    class SubstituteGlobalsInExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        SubstituteGlobalsInExprVisitor() {
        }

        @Override
        protected void visitGlobalNode(GlobalNode globalNode) {
            PrimitiveData primitiveData;
            PrimitiveData primitiveData2 = primitiveData = SubstituteGlobalsVisitor.this.compileTimeGlobals != null ? (PrimitiveData)SubstituteGlobalsVisitor.this.compileTimeGlobals.get(globalNode.getName()) : null;
            if (primitiveData == null) {
                if (SubstituteGlobalsVisitor.this.shouldAssertNoUnboundGlobals) {
                    throw new SoySyntaxException("Found unbound global '" + globalNode.getName() + "'.");
                }
                return;
            }
            globalNode.getParent().replaceChild(globalNode, DataUtils.convertPrimitiveDataToExpr(primitiveData));
        }

        @Override
        protected void visitExprNode(ExprNode exprNode) {
            if (exprNode instanceof ExprNode.ParentExprNode) {
                this.visitChildrenAllowingConcurrentModification((ExprNode.ParentExprNode)exprNode);
            }
        }
    }
}

