/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.opti;

import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.internalutils.DataUtils;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.shared.internal.NonpluginFunction;
import com.google.template.soy.sharedpasses.opti.PreevalVisitor;
import com.google.template.soy.sharedpasses.opti.PreevalVisitorFactory;
import com.google.template.soy.sharedpasses.render.RenderException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import javax.inject.Inject;

class SimplifyExprVisitor
extends AbstractExprNodeVisitor<Void> {
    private static final Deque<Map<String, SoyData>> EMPTY_ENV = new ArrayDeque<Map<String, SoyData>>(0);
    private final PreevalVisitor preevalVisitor;

    @Inject
    SimplifyExprVisitor(PreevalVisitorFactory preevalVisitorFactory) {
        this.preevalVisitor = preevalVisitorFactory.create(null, EMPTY_ENV);
    }

    @Override
    protected void visitExprRootNode(ExprRootNode<?> exprRootNode) {
        this.visit((ExprNode)exprRootNode.getChild(0));
    }

    @Override
    protected void visitListLiteralNode(ListLiteralNode listLiteralNode) {
        this.visitChildren(listLiteralNode);
    }

    @Override
    protected void visitMapLiteralNode(MapLiteralNode mapLiteralNode) {
        this.visitChildren(mapLiteralNode);
    }

    @Override
    protected void visitAndOpNode(OperatorNodes.AndOpNode andOpNode) {
        this.visitChildren(andOpNode);
        SoyData soyData = SimplifyExprVisitor.getConstantOrNull(andOpNode.getChild(0));
        SoyData soyData2 = SimplifyExprVisitor.getConstantOrNull(andOpNode.getChild(1));
        if (soyData == null && soyData2 == null) {
            return;
        }
        ExprNode exprNode = soyData != null && soyData2 != null ? new BooleanNode(soyData.toBoolean() && soyData2.toBoolean()) : (soyData != null ? (soyData.toBoolean() ? andOpNode.getChild(1) : new BooleanNode(false)) : (soyData2.toBoolean() ? andOpNode.getChild(0) : new BooleanNode(false)));
        andOpNode.getParent().replaceChild(andOpNode, exprNode);
    }

    @Override
    protected void visitOrOpNode(OperatorNodes.OrOpNode orOpNode) {
        this.visitChildren(orOpNode);
        SoyData soyData = SimplifyExprVisitor.getConstantOrNull(orOpNode.getChild(0));
        SoyData soyData2 = SimplifyExprVisitor.getConstantOrNull(orOpNode.getChild(1));
        if (soyData == null && soyData2 == null) {
            return;
        }
        ExprNode exprNode = soyData != null && soyData2 != null ? new BooleanNode(soyData.toBoolean() || soyData2.toBoolean()) : (soyData != null ? (soyData.toBoolean() ? new BooleanNode(true) : orOpNode.getChild(1)) : (soyData2.toBoolean() ? new BooleanNode(true) : orOpNode.getChild(0)));
        orOpNode.getParent().replaceChild(orOpNode, exprNode);
    }

    @Override
    protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode conditionalOpNode) {
        this.visitChildren(conditionalOpNode);
        SoyData soyData = SimplifyExprVisitor.getConstantOrNull(conditionalOpNode.getChild(0));
        if (soyData == null) {
            return;
        }
        ExprNode exprNode = soyData.toBoolean() ? conditionalOpNode.getChild(1) : conditionalOpNode.getChild(2);
        conditionalOpNode.getParent().replaceChild(conditionalOpNode, exprNode);
    }

    @Override
    protected void visitFunctionNode(FunctionNode functionNode) {
        if (NonpluginFunction.forFunctionName(functionNode.getFunctionName()) != null) {
            return;
        }
        this.visitExprNode(functionNode);
    }

    @Override
    protected void visitExprNode(ExprNode exprNode) {
        SoyData soyData;
        ExprNode exprNode22;
        if (!(exprNode instanceof ExprNode.ParentExprNode)) {
            return;
        }
        ExprNode.ParentExprNode parentExprNode = (ExprNode.ParentExprNode)exprNode;
        this.visitChildren(parentExprNode);
        for (ExprNode exprNode22 : parentExprNode.getChildren()) {
            if (exprNode22 instanceof ExprNode.ConstantNode) continue;
            return;
        }
        try {
            soyData = (SoyData)this.preevalVisitor.exec(parentExprNode);
        }
        catch (RenderException renderException) {
            return;
        }
        exprNode22 = DataUtils.convertPrimitiveDataToExpr((PrimitiveData)soyData);
        parentExprNode.getParent().replaceChild(parentExprNode, exprNode22);
    }

    private static SoyData getConstantOrNull(ExprNode exprNode) {
        switch (exprNode.getKind()) {
            case NULL_NODE: {
                return NullData.INSTANCE;
            }
            case BOOLEAN_NODE: {
                return BooleanData.forValue(((BooleanNode)exprNode).getValue());
            }
            case INTEGER_NODE: {
                return IntegerData.forValue(((IntegerNode)exprNode).getValue());
            }
            case FLOAT_NODE: {
                return FloatData.forValue(((FloatNode)exprNode).getValue());
            }
            case STRING_NODE: {
                return StringData.forValue(((StringNode)exprNode).getValue());
            }
        }
        return null;
    }
}

