/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.collect.Maps;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.CollectionData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.shared.internal.NonpluginFunction;
import com.google.template.soy.shared.restricted.SoyJavaRuntimeFunction;
import com.google.template.soy.sharedpasses.render.RenderException;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class EvalVisitor
extends AbstractReturningExprNodeVisitor<SoyData> {
    private final Map<String, SoyJavaRuntimeFunction> soyJavaRuntimeFunctionsMap;
    private final SoyMapData data;
    private final SoyMapData ijData;
    private final Deque<Map<String, SoyData>> env;

    protected EvalVisitor(@Nullable Map<String, SoyJavaRuntimeFunction> map, @Nullable SoyMapData soyMapData, @Nullable SoyMapData soyMapData2, Deque<Map<String, SoyData>> deque) {
        this.soyJavaRuntimeFunctionsMap = map;
        this.data = soyMapData;
        this.ijData = soyMapData2;
        this.env = deque;
    }

    @Override
    protected SoyData visitExprRootNode(ExprRootNode<?> exprRootNode) {
        return (SoyData)this.visit((ExprNode)exprRootNode.getChild(0));
    }

    @Override
    protected SoyData visitNullNode(NullNode nullNode) {
        return NullData.INSTANCE;
    }

    @Override
    protected SoyData visitBooleanNode(BooleanNode booleanNode) {
        return this.convertResult(booleanNode.getValue());
    }

    @Override
    protected SoyData visitIntegerNode(IntegerNode integerNode) {
        return this.convertResult(integerNode.getValue());
    }

    @Override
    protected SoyData visitFloatNode(FloatNode floatNode) {
        return this.convertResult(floatNode.getValue());
    }

    @Override
    protected SoyData visitStringNode(StringNode stringNode) {
        return this.convertResult(stringNode.getValue());
    }

    @Override
    protected SoyData visitListLiteralNode(ListLiteralNode listLiteralNode) {
        return new SoyListData(this.visitChildren(listLiteralNode));
    }

    @Override
    protected SoyData visitMapLiteralNode(MapLiteralNode mapLiteralNode) {
        HashMap hashMap = Maps.newHashMap();
        int n = mapLiteralNode.numChildren();
        for (int i = 0; i < n; i += 2) {
            SoyData soyData = (SoyData)this.visit(mapLiteralNode.getChild(i));
            if (!(soyData instanceof StringData)) {
                throw new RenderException("Maps must have string keys (key \"" + mapLiteralNode.getChild(i).toSourceString() + "\"" + " in map " + mapLiteralNode.toSourceString() + " does not evaluate to a string).");
            }
            SoyData soyData2 = (SoyData)this.visit(mapLiteralNode.getChild(i + 1));
            hashMap.put(soyData.stringValue(), soyData2);
        }
        return new SoyMapData(hashMap);
    }

    @Override
    protected SoyData visitDataRefNode(DataRefNode dataRefNode) {
        SoyData soyData = this.resolveDataRefFirstKey(dataRefNode);
        if (dataRefNode.numChildren() == 1) {
            return soyData;
        }
        SoyData soyData2 = soyData;
        for (int i = 1; i < dataRefNode.numChildren(); ++i) {
            if (!(soyData2 instanceof CollectionData)) {
                return UndefinedData.INSTANCE;
            }
            ExprNode exprNode = dataRefNode.getChild(i);
            if (exprNode instanceof DataRefKeyNode) {
                soyData2 = ((CollectionData)soyData2).getSingle(((DataRefKeyNode)exprNode).getKey());
                continue;
            }
            if (exprNode instanceof DataRefIndexNode) {
                soyData2 = ((SoyListData)soyData2).get(((DataRefIndexNode)exprNode).getIndex());
                continue;
            }
            if (exprNode instanceof GlobalNode) {
                throw new UnsupportedOperationException();
            }
            SoyData soyData3 = (SoyData)this.visit(exprNode);
            soyData2 = soyData3 instanceof IntegerData ? ((SoyListData)soyData2).get(((IntegerData)soyData3).getValue()) : ((CollectionData)soyData2).getSingle(soyData3.toString());
        }
        if (soyData2 != null) {
            return soyData2;
        }
        return UndefinedData.INSTANCE;
    }

    @Override
    protected SoyData visitNegativeOpNode(OperatorNodes.NegativeOpNode negativeOpNode) {
        SoyData soyData = (SoyData)this.visit(negativeOpNode.getChild(0));
        if (soyData instanceof IntegerData) {
            return this.convertResult(-soyData.integerValue());
        }
        return this.convertResult(-soyData.floatValue());
    }

    @Override
    protected SoyData visitNotOpNode(OperatorNodes.NotOpNode notOpNode) {
        SoyData soyData = (SoyData)this.visit(notOpNode.getChild(0));
        return this.convertResult(!soyData.toBoolean());
    }

    @Override
    protected SoyData visitTimesOpNode(OperatorNodes.TimesOpNode timesOpNode) {
        SoyData soyData = (SoyData)this.visit(timesOpNode.getChild(0));
        SoyData soyData2 = (SoyData)this.visit(timesOpNode.getChild(1));
        if (soyData instanceof IntegerData && soyData2 instanceof IntegerData) {
            return this.convertResult(soyData.integerValue() * soyData2.integerValue());
        }
        return this.convertResult(soyData.numberValue() * soyData2.numberValue());
    }

    @Override
    protected SoyData visitDivideByOpNode(OperatorNodes.DivideByOpNode divideByOpNode) {
        SoyData soyData = (SoyData)this.visit(divideByOpNode.getChild(0));
        SoyData soyData2 = (SoyData)this.visit(divideByOpNode.getChild(1));
        return this.convertResult(soyData.numberValue() / soyData2.numberValue());
    }

    @Override
    protected SoyData visitModOpNode(OperatorNodes.ModOpNode modOpNode) {
        SoyData soyData = (SoyData)this.visit(modOpNode.getChild(0));
        SoyData soyData2 = (SoyData)this.visit(modOpNode.getChild(1));
        return this.convertResult(soyData.integerValue() % soyData2.integerValue());
    }

    @Override
    protected SoyData visitPlusOpNode(OperatorNodes.PlusOpNode plusOpNode) {
        SoyData soyData = (SoyData)this.visit(plusOpNode.getChild(0));
        SoyData soyData2 = (SoyData)this.visit(plusOpNode.getChild(1));
        if (soyData instanceof IntegerData && soyData2 instanceof IntegerData) {
            return this.convertResult(soyData.integerValue() + soyData2.integerValue());
        }
        if (soyData instanceof StringData || soyData2 instanceof StringData) {
            return this.convertResult(soyData.toString() + soyData2.toString());
        }
        return this.convertResult(soyData.numberValue() + soyData2.numberValue());
    }

    @Override
    protected SoyData visitMinusOpNode(OperatorNodes.MinusOpNode minusOpNode) {
        SoyData soyData = (SoyData)this.visit(minusOpNode.getChild(0));
        SoyData soyData2 = (SoyData)this.visit(minusOpNode.getChild(1));
        if (soyData instanceof IntegerData && soyData2 instanceof IntegerData) {
            return this.convertResult(soyData.integerValue() - soyData2.integerValue());
        }
        return this.convertResult(soyData.numberValue() - soyData2.numberValue());
    }

    @Override
    protected SoyData visitLessThanOpNode(OperatorNodes.LessThanOpNode lessThanOpNode) {
        SoyData soyData = (SoyData)this.visit(lessThanOpNode.getChild(0));
        SoyData soyData2 = (SoyData)this.visit(lessThanOpNode.getChild(1));
        if (soyData instanceof IntegerData && soyData2 instanceof IntegerData) {
            return this.convertResult(soyData.integerValue() < soyData2.integerValue());
        }
        return this.convertResult(soyData.numberValue() < soyData2.numberValue());
    }

    @Override
    protected SoyData visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode greaterThanOpNode) {
        SoyData soyData = (SoyData)this.visit(greaterThanOpNode.getChild(0));
        SoyData soyData2 = (SoyData)this.visit(greaterThanOpNode.getChild(1));
        if (soyData instanceof IntegerData && soyData2 instanceof IntegerData) {
            return this.convertResult(soyData.integerValue() > soyData2.integerValue());
        }
        return this.convertResult(soyData.numberValue() > soyData2.numberValue());
    }

    @Override
    protected SoyData visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode lessThanOrEqualOpNode) {
        SoyData soyData = (SoyData)this.visit(lessThanOrEqualOpNode.getChild(0));
        SoyData soyData2 = (SoyData)this.visit(lessThanOrEqualOpNode.getChild(1));
        if (soyData instanceof IntegerData && soyData2 instanceof IntegerData) {
            return this.convertResult(soyData.integerValue() <= soyData2.integerValue());
        }
        return this.convertResult(soyData.numberValue() <= soyData2.numberValue());
    }

    @Override
    protected SoyData visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode greaterThanOrEqualOpNode) {
        SoyData soyData = (SoyData)this.visit(greaterThanOrEqualOpNode.getChild(0));
        SoyData soyData2 = (SoyData)this.visit(greaterThanOrEqualOpNode.getChild(1));
        if (soyData instanceof IntegerData && soyData2 instanceof IntegerData) {
            return this.convertResult(soyData.integerValue() >= soyData2.integerValue());
        }
        return this.convertResult(soyData.numberValue() >= soyData2.numberValue());
    }

    @Override
    protected SoyData visitEqualOpNode(OperatorNodes.EqualOpNode equalOpNode) {
        SoyData soyData = (SoyData)this.visit(equalOpNode.getChild(0));
        SoyData soyData2 = (SoyData)this.visit(equalOpNode.getChild(1));
        return this.convertResult(soyData.equals(soyData2));
    }

    @Override
    protected SoyData visitNotEqualOpNode(OperatorNodes.NotEqualOpNode notEqualOpNode) {
        SoyData soyData;
        SoyData soyData2 = (SoyData)this.visit(notEqualOpNode.getChild(0));
        return this.convertResult(!soyData2.equals(soyData = (SoyData)this.visit(notEqualOpNode.getChild(1))));
    }

    @Override
    protected SoyData visitAndOpNode(OperatorNodes.AndOpNode andOpNode) {
        SoyData soyData = (SoyData)this.visit(andOpNode.getChild(0));
        if (!soyData.toBoolean()) {
            return this.convertResult(false);
        }
        SoyData soyData2 = (SoyData)this.visit(andOpNode.getChild(1));
        return this.convertResult(soyData2.toBoolean());
    }

    @Override
    protected SoyData visitOrOpNode(OperatorNodes.OrOpNode orOpNode) {
        SoyData soyData = (SoyData)this.visit(orOpNode.getChild(0));
        if (soyData.toBoolean()) {
            return this.convertResult(true);
        }
        SoyData soyData2 = (SoyData)this.visit(orOpNode.getChild(1));
        return this.convertResult(soyData2.toBoolean());
    }

    @Override
    protected SoyData visitConditionalOpNode(OperatorNodes.ConditionalOpNode conditionalOpNode) {
        SoyData soyData = (SoyData)this.visit(conditionalOpNode.getChild(0));
        if (soyData.toBoolean()) {
            return (SoyData)this.visit(conditionalOpNode.getChild(1));
        }
        return (SoyData)this.visit(conditionalOpNode.getChild(2));
    }

    @Override
    protected SoyData visitFunctionNode(FunctionNode functionNode) {
        String string = functionNode.getFunctionName();
        int n = functionNode.numChildren();
        NonpluginFunction nonpluginFunction = NonpluginFunction.forFunctionName(string);
        if (nonpluginFunction != null) {
            if (n != nonpluginFunction.getNumArgs()) {
                throw new RenderException("Function '" + string + "' called with the wrong number of arguments" + " (function call \"" + functionNode.toSourceString() + "\").");
            }
            switch (nonpluginFunction) {
                case IS_FIRST: {
                    return this.visitIsFirstFunction(functionNode);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(functionNode);
                }
                case INDEX: {
                    return this.visitIndexFunction(functionNode);
                }
                case HAS_DATA: {
                    return this.visitHasDataFunction();
                }
            }
            throw new AssertionError();
        }
        List<SoyData> list = this.visitChildren(functionNode);
        return this.computeFunction(string, list, functionNode);
    }

    protected SoyData computeFunction(String string, List<SoyData> list, FunctionNode functionNode) {
        SoyJavaRuntimeFunction soyJavaRuntimeFunction = this.soyJavaRuntimeFunctionsMap.get(string);
        if (soyJavaRuntimeFunction == null) {
            throw new RenderException("Failed to find Soy function with name '" + string + "'" + " (function call \"" + functionNode.toSourceString() + "\").");
        }
        return this.computeFunctionHelper(soyJavaRuntimeFunction, list, functionNode);
    }

    protected SoyData computeFunctionHelper(SoyJavaRuntimeFunction soyJavaRuntimeFunction, List<SoyData> list, FunctionNode functionNode) {
        try {
            return soyJavaRuntimeFunction.compute(list);
        }
        catch (Exception exception) {
            throw new RenderException("Error while computing function \"" + functionNode.toSourceString() + "\": " + exception.getMessage());
        }
    }

    private SoyData visitIsFirstFunction(FunctionNode functionNode) {
        int n;
        try {
            DataRefNode dataRefNode = (DataRefNode)functionNode.getChild(0);
            String string = dataRefNode.getFirstKey();
            n = this.getLocalVar(string + "__index").integerValue();
        }
        catch (Exception exception) {
            throw new RenderException("Failed to evaluate function call " + functionNode.toSourceString() + ".");
        }
        return this.convertResult(n == 0);
    }

    private SoyData visitIsLastFunction(FunctionNode functionNode) {
        int n;
        int n2;
        try {
            DataRefNode dataRefNode = (DataRefNode)functionNode.getChild(0);
            String string = dataRefNode.getFirstKey();
            n2 = this.getLocalVar(string + "__index").integerValue();
            n = this.getLocalVar(string + "__lastIndex").integerValue();
        }
        catch (Exception exception) {
            throw new RenderException("Failed to evaluate function call " + functionNode.toSourceString() + ".");
        }
        return this.convertResult(n2 == n);
    }

    private SoyData visitIndexFunction(FunctionNode functionNode) {
        int n;
        try {
            DataRefNode dataRefNode = (DataRefNode)functionNode.getChild(0);
            String string = dataRefNode.getFirstKey();
            n = this.getLocalVar(string + "__index").integerValue();
        }
        catch (Exception exception) {
            throw new RenderException("Failed to evaluate function call " + functionNode.toSourceString() + ".");
        }
        return this.convertResult(n);
    }

    private SoyData visitHasDataFunction() {
        return this.convertResult(this.data != null);
    }

    private SoyData convertResult(boolean bl) {
        return BooleanData.forValue(bl);
    }

    private SoyData convertResult(int n) {
        return IntegerData.forValue(n);
    }

    private SoyData convertResult(double d) {
        return FloatData.forValue(d);
    }

    private SoyData convertResult(String string) {
        return StringData.forValue(string);
    }

    private SoyData getLocalVar(String string) {
        for (Map<String, SoyData> map : this.env) {
            SoyData soyData = map.get(string);
            if (soyData == null) continue;
            return soyData;
        }
        throw new AssertionError();
    }

    protected SoyData resolveDataRefFirstKey(DataRefNode dataRefNode) {
        String string = dataRefNode.getFirstKey();
        SoyData soyData = null;
        if (dataRefNode.isIjDataRef()) {
            soyData = this.ijData.getSingle(string);
        } else {
            Boolean bl = dataRefNode.isLocalVarDataRef();
            if ((bl == Boolean.TRUE || bl == null) && this.env != null) {
                Map<String, SoyData> map;
                Iterator<Map<String, SoyData>> iterator = this.env.iterator();
                while (iterator.hasNext() && (soyData = (map = iterator.next()).get(string)) == null) {
                }
            }
            if (bl == Boolean.FALSE || bl == null && soyData == null) {
                soyData = this.data.getSingle(string);
            }
        }
        return soyData != null ? soyData : UndefinedData.INSTANCE;
    }

    public static interface EvalVisitorFactory {
        public EvalVisitor create(@Nullable SoyMapData var1, @Nullable SoyMapData var2, Deque<Map<String, SoyData>> var3);
    }
}

