/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.internal.AugmentedSoyMapData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralCaseSpec;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.restricted.SoyJavaRuntimePrintDirective;
import com.google.template.soy.sharedpasses.render.EvalVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgPluralRemainderNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import com.google.template.soy.soytree.jssrc.GoogMsgRefNode;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ULocale;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class RenderVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final Map<String, SoyJavaRuntimePrintDirective> soyJavaRuntimeDirectivesMap;
    private final EvalVisitor.EvalVisitorFactory evalVisitorFactory;
    private final RenderVisitorFactory renderVisitorFactory;
    private final StringBuilder outputSb;
    private final TemplateRegistry templateRegistry;
    private final SoyMapData data;
    private final SoyMapData ijData;
    private final Deque<Map<String, SoyData>> env;
    private final Set<String> activeDelPackageNames;
    private final SoyMsgBundle msgBundle;
    private final SoyCssRenamingMap cssRenamingMap;
    private EvalVisitor evalVisitor;
    private SoyListData foreachList;
    private int currPluralRemainderValue;

    protected RenderVisitor(@Nullable Map<String, SoyJavaRuntimePrintDirective> map, EvalVisitor.EvalVisitorFactory evalVisitorFactory, RenderVisitorFactory renderVisitorFactory, StringBuilder stringBuilder, @Nullable TemplateRegistry templateRegistry, @Nullable SoyMapData soyMapData, @Nullable SoyMapData soyMapData2, @Nullable Deque<Map<String, SoyData>> arrayDeque, @Nullable Set<String> set, @Nullable SoyMsgBundle soyMsgBundle, @Nullable SoyCssRenamingMap soyCssRenamingMap) {
        this.soyJavaRuntimeDirectivesMap = map;
        this.evalVisitorFactory = evalVisitorFactory;
        this.renderVisitorFactory = renderVisitorFactory;
        this.outputSb = stringBuilder;
        this.templateRegistry = templateRegistry;
        this.data = soyMapData;
        this.ijData = soyMapData2;
        this.env = arrayDeque != null ? arrayDeque : new ArrayDeque();
        this.activeDelPackageNames = set;
        this.msgBundle = soyMsgBundle;
        this.cssRenamingMap = soyCssRenamingMap;
        this.evalVisitor = null;
        this.currPluralRemainderValue = -1;
    }

    @Override
    protected void visitTemplateNode(TemplateNode templateNode) {
        try {
            this.visitBlockHelper(templateNode);
        }
        catch (RenderException renderException) {
            throw renderException.getTemplateName() != null ? renderException : renderException.setTemplateName(templateNode.getTemplateName());
        }
    }

    @Override
    protected void visitRawTextNode(RawTextNode rawTextNode) {
        this.outputSb.append(rawTextNode.getRawText());
    }

    @Override
    protected void visitMsgNode(MsgNode msgNode) {
        SoyMsg soyMsg;
        boolean bl;
        boolean bl2 = bl = msgNode.needsEnvFrameDuringInterp() != Boolean.FALSE;
        if (bl) {
            this.env.push(Maps.newHashMap());
        }
        if (this.msgBundle != null) {
            long l = MsgUtils.computeMsgId(msgNode);
            soyMsg = this.msgBundle.getMsg(l);
        } else {
            soyMsg = null;
        }
        if (soyMsg != null) {
            List<SoyMsgPart> list = soyMsg.getParts();
            if (list.size() > 0) {
                SoyMsgPart soyMsgPart = list.get(0);
                if (soyMsgPart instanceof SoyMsgPluralPart) {
                    new PluralSelectMsgPartsVisitor(msgNode, new ULocale(soyMsg.getLocaleString())).visitPart((SoyMsgPluralPart)soyMsgPart);
                } else if (soyMsgPart instanceof SoyMsgSelectPart) {
                    new PluralSelectMsgPartsVisitor(msgNode, new ULocale(soyMsg.getLocaleString())).visitPart((SoyMsgSelectPart)soyMsgPart);
                } else {
                    for (SoyMsgPart soyMsgPart2 : list) {
                        if (soyMsgPart2 instanceof SoyMsgRawTextPart) {
                            this.outputSb.append(((SoyMsgRawTextPart)soyMsgPart2).getRawText());
                            continue;
                        }
                        if (soyMsgPart2 instanceof SoyMsgPlaceholderPart) {
                            String string = ((SoyMsgPlaceholderPart)soyMsgPart2).getPlaceholderName();
                            this.visit(msgNode.getRepPlaceholderNode(string));
                            continue;
                        }
                        throw new AssertionError();
                    }
                }
            }
        } else {
            this.visitChildren(msgNode);
        }
        if (bl) {
            this.env.pop();
        }
    }

    @Override
    protected void visitMsgPluralNode(MsgPluralNode msgPluralNode) {
        int n;
        ExprRootNode<?> exprRootNode = msgPluralNode.getExpr();
        try {
            n = this.eval(exprRootNode).integerValue();
        }
        catch (SoyDataException soyDataException) {
            throw new RenderException(String.format("Plural expression \"%s\" doesn't evaluate to integer.", exprRootNode.toSourceString()));
        }
        this.currPluralRemainderValue = n - msgPluralNode.getOffset();
        for (CaseOrDefaultNode caseOrDefaultNode : msgPluralNode.getChildren()) {
            if (caseOrDefaultNode instanceof MsgPluralDefaultNode) {
                this.visitChildren(caseOrDefaultNode);
                break;
            }
            if (((MsgPluralCaseNode)caseOrDefaultNode).getCaseNumber() != n) continue;
            this.visitChildren(caseOrDefaultNode);
            break;
        }
        this.currPluralRemainderValue = -1;
    }

    @Override
    protected void visitMsgPluralCaseNode(MsgPluralCaseNode msgPluralCaseNode) {
        throw new AssertionError();
    }

    @Override
    protected void visitMsgPluralDefaultNode(MsgPluralDefaultNode msgPluralDefaultNode) {
        throw new AssertionError();
    }

    @Override
    protected void visitMsgPluralRemainderNode(MsgPluralRemainderNode msgPluralRemainderNode) {
        this.outputSb.append(this.currPluralRemainderValue);
    }

    @Override
    protected void visitMsgSelectNode(MsgSelectNode msgSelectNode) {
        String string;
        ExprRootNode<?> exprRootNode = msgSelectNode.getExpr();
        try {
            string = this.eval(exprRootNode).stringValue();
        }
        catch (SoyDataException soyDataException) {
            throw new RenderException(String.format("Select expression \"%s\" doesn't evaluate to string.", exprRootNode.toSourceString()));
        }
        for (CaseOrDefaultNode caseOrDefaultNode : msgSelectNode.getChildren()) {
            if (caseOrDefaultNode instanceof MsgSelectDefaultNode) {
                this.visitChildren(caseOrDefaultNode);
                continue;
            }
            if (!((MsgSelectCaseNode)caseOrDefaultNode).getCaseValue().equals(string)) continue;
            this.visitChildren(caseOrDefaultNode);
            return;
        }
    }

    @Override
    protected void visitMsgSelectCaseNode(MsgSelectCaseNode msgSelectCaseNode) {
        throw new AssertionError();
    }

    @Override
    protected void visitMsgSelectDefaultNode(MsgSelectDefaultNode msgSelectDefaultNode) {
        throw new AssertionError();
    }

    @Override
    protected void visitGoogMsgNode(GoogMsgNode googMsgNode) {
        throw new AssertionError();
    }

    @Override
    protected void visitGoogMsgRefNode(GoogMsgRefNode googMsgRefNode) {
        throw new AssertionError();
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode msgHtmlTagNode) {
        this.visitChildren(msgHtmlTagNode);
    }

    @Override
    protected void visitPrintNode(PrintNode printNode) {
        SoyData soyData = this.eval(printNode.getExprUnion().getExpr());
        if (soyData instanceof UndefinedData) {
            throw new RenderException("In 'print' tag, expression \"" + printNode.getExprText() + "\" evaluates to undefined.");
        }
        for (PrintDirectiveNode printDirectiveNode : printNode.getChildren()) {
            List<ExprRootNode<?>> list = printDirectiveNode.getArgs();
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
            for (ExprRootNode<?> exprRootNode : list) {
                arrayList.add(this.evalVisitor.exec(exprRootNode));
            }
            String string = this.applyDirective(printDirectiveNode.getName(), soyData, arrayList, printNode);
            soyData = StringData.forValue(string);
        }
        this.outputSb.append(soyData);
    }

    protected String applyDirective(String string, SoyData soyData, List<SoyData> list, PrintNode printNode) {
        SoyJavaRuntimePrintDirective soyJavaRuntimePrintDirective = this.soyJavaRuntimeDirectivesMap.get(string);
        if (soyJavaRuntimePrintDirective == null) {
            throw new RenderException("Failed to find Soy print directive with name '" + string + "'" + " (tag " + printNode.toSourceString() + ")");
        }
        if (!soyJavaRuntimePrintDirective.getValidArgsSizes().contains(list.size())) {
            throw new RenderException("Print directive '" + string + "' used with the wrong number of" + " arguments (tag " + printNode.toSourceString() + ").");
        }
        try {
            return soyJavaRuntimePrintDirective.apply(soyData, list);
        }
        catch (RuntimeException runtimeException) {
            throw new RenderException(String.format("Failed in applying directive '%s' in tag \"%s\" due to exception: %s", string, printNode.toSourceString(), runtimeException.getMessage()));
        }
    }

    @Override
    protected void visitCssNode(CssNode cssNode) {
        String string;
        ExprRootNode<?> exprRootNode = cssNode.getComponentNameExpr();
        if (exprRootNode != null) {
            this.outputSb.append(this.eval(exprRootNode).toString()).append("-");
        }
        String string2 = cssNode.getSelectorText();
        if (this.cssRenamingMap != null && (string = this.cssRenamingMap.get(string2)) != null) {
            string2 = string;
        }
        this.outputSb.append(string2);
    }

    @Override
    protected void visitLetValueNode(LetValueNode letValueNode) {
        this.env.peek().put(letValueNode.getVarName(), this.eval(letValueNode.getValueExpr()));
    }

    @Override
    protected void visitLetContentNode(LetContentNode letContentNode) {
        this.env.peek().put(letContentNode.getVarName(), this.renderChildren(letContentNode));
    }

    @Override
    protected void visitIfNode(IfNode ifNode) {
        for (SoyNode soyNode : ifNode.getChildren()) {
            if (soyNode instanceof IfCondNode) {
                IfCondNode ifCondNode = (IfCondNode)soyNode;
                if (!this.eval(ifCondNode.getExprUnion().getExpr()).toBoolean()) continue;
                this.visit(ifCondNode);
                return;
            }
            if (soyNode instanceof IfElseNode) {
                this.visit(soyNode);
                return;
            }
            throw new AssertionError();
        }
    }

    @Override
    protected void visitSwitchNode(SwitchNode switchNode) {
        SoyData soyData = this.eval(switchNode.getExpr());
        for (SoyNode soyNode : switchNode.getChildren()) {
            if (soyNode instanceof SwitchCaseNode) {
                SwitchCaseNode switchCaseNode = (SwitchCaseNode)soyNode;
                for (ExprRootNode<?> exprRootNode : switchCaseNode.getExprList()) {
                    if (!soyData.equals(this.eval(exprRootNode))) continue;
                    this.visit(switchCaseNode);
                    return;
                }
                continue;
            }
            if (soyNode instanceof SwitchDefaultNode) {
                this.visit(soyNode);
                return;
            }
            throw new AssertionError();
        }
    }

    @Override
    protected void visitForeachNode(ForeachNode foreachNode) {
        SoyData soyData = this.eval(foreachNode.getExpr());
        if (!(soyData instanceof SoyListData)) {
            throw new RenderException("In 'foreach' command " + foreachNode.toSourceString() + ", the data reference does not resolve to a SoyListData.");
        }
        this.foreachList = (SoyListData)soyData;
        if (this.foreachList.length() > 0) {
            this.visit((SoyNode)foreachNode.getChild(0));
        } else if (foreachNode.numChildren() == 2) {
            this.visit((SoyNode)foreachNode.getChild(1));
        }
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode foreachNonemptyNode) {
        SoyListData soyListData = this.foreachList;
        this.foreachList = null;
        String string = foreachNonemptyNode.getVarName();
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(string + "__lastIndex", IntegerData.forValue(soyListData.length() - 1));
        this.env.push(hashMap);
        for (int i = 0; i < soyListData.length(); ++i) {
            hashMap.put(string + "__index", IntegerData.forValue(i));
            hashMap.put(string, soyListData.get(i));
            this.visitChildren(foreachNonemptyNode);
        }
        this.env.pop();
    }

    @Override
    protected void visitForNode(ForNode forNode) {
        ArrayList arrayList = Lists.newArrayList();
        for (ExprRootNode<?> exprRootNode : forNode.getRangeArgs()) {
            SoyData soyData = this.eval(exprRootNode);
            if (!(soyData instanceof IntegerData)) {
                throw new RenderException("In 'for' command " + forNode.toSourceString() + ", the expression \"" + exprRootNode.toSourceString() + "\" does not resolve to an integer.");
            }
            arrayList.add(((IntegerData)soyData).getValue());
        }
        int n = arrayList.size() == 3 ? (Integer)arrayList.remove(2) : 1;
        int n2 = arrayList.size() == 2 ? (Integer)arrayList.remove(0) : 0;
        int n3 = (Integer)arrayList.get(0);
        String string = forNode.getVarName();
        HashMap hashMap = Maps.newHashMap();
        this.env.push(hashMap);
        for (int i = n2; i < n3; i += n) {
            hashMap.put(string, IntegerData.forValue(i));
            this.visitChildren(forNode);
        }
        this.env.pop();
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode callBasicNode) {
        TemplateBasicNode templateBasicNode = this.templateRegistry.getBasicTemplate(callBasicNode.getCalleeName());
        if (templateBasicNode == null) {
            throw new RenderException("Attempting to render undefined template '" + callBasicNode.getCalleeName() + "'.");
        }
        this.visitCallNodeHelper(callBasicNode, templateBasicNode);
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode callDelegateNode) {
        TemplateDelegateNode templateDelegateNode;
        try {
            templateDelegateNode = this.templateRegistry.selectDelegateTemplate(callDelegateNode.getDelCalleeName(), this.activeDelPackageNames);
        }
        catch (TemplateRegistry.DelegateTemplateConflictException delegateTemplateConflictException) {
            throw new RenderException(delegateTemplateConflictException.getMessage());
        }
        if (templateDelegateNode == null) {
            return;
        }
        this.visitCallNodeHelper(callDelegateNode, templateDelegateNode);
    }

    private void visitCallNodeHelper(CallNode callNode, TemplateNode templateNode) {
        SoyData soyData;
        SoyMapData soyMapData;
        if (callNode.isPassingAllData()) {
            soyMapData = this.data;
        } else if (callNode.isPassingData()) {
            soyData = this.eval(callNode.getExpr());
            if (!(soyData instanceof SoyMapData)) {
                throw new RenderException("In 'call' command " + callNode.toSourceString() + ", the data reference does not resolve to a SoyMapData.");
            }
            soyMapData = (SoyMapData)soyData;
        } else {
            soyMapData = null;
        }
        soyData = !callNode.isPassingData() ? new SoyMapData() : (callNode.numChildren() == 0 ? soyMapData : new AugmentedSoyMapData(soyMapData));
        for (CallParamNode callParamNode : callNode.getChildren()) {
            if (callParamNode instanceof CallParamValueNode) {
                ((SoyMapData)soyData).putSingle(callParamNode.getKey(), this.eval(((CallParamValueNode)callParamNode).getValueExprUnion().getExpr()));
                continue;
            }
            if (callParamNode instanceof CallParamContentNode) {
                ((SoyMapData)soyData).putSingle(callParamNode.getKey(), this.renderChildren((CallParamContentNode)callParamNode));
                continue;
            }
            throw new AssertionError();
        }
        RenderVisitor renderVisitor = this.renderVisitorFactory.create(this.outputSb, this.templateRegistry, (SoyMapData)soyData, this.ijData, null, this.activeDelPackageNames, this.msgBundle, this.cssRenamingMap);
        renderVisitor.exec(templateNode);
    }

    @Override
    protected void visitCallParamNode(CallParamNode callParamNode) {
        throw new AssertionError();
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            if (soyNode instanceof SoyNode.BlockNode) {
                this.visitBlockHelper((SoyNode.BlockNode)soyNode);
            } else {
                this.visitChildren((SoyNode.ParentSoyNode)soyNode);
            }
        }
    }

    private void visitBlockHelper(SoyNode.BlockNode blockNode) {
        if (blockNode.needsEnvFrameDuringInterp() != Boolean.FALSE) {
            this.env.push(Maps.newHashMap());
            this.visitChildren(blockNode);
            this.env.pop();
        } else {
            this.visitChildren(blockNode);
        }
    }

    private SoyData eval(ExprNode exprNode) {
        if (exprNode == null) {
            throw new RenderException("Cannot evaluate expression in V1 syntax.");
        }
        if (this.evalVisitor == null) {
            this.evalVisitor = this.evalVisitorFactory.create(this.data, this.ijData, this.env);
        }
        try {
            return (SoyData)this.evalVisitor.exec(exprNode);
        }
        catch (Exception exception) {
            throw new RenderException("When evaluating \"" + exprNode.toSourceString() + "\": " + exception.getMessage());
        }
    }

    private StringData renderChildren(SoyNode.BlockNode blockNode) {
        StringBuilder stringBuilder = new StringBuilder();
        RenderVisitor renderVisitor = this.renderVisitorFactory.create(stringBuilder, this.templateRegistry, this.data, this.ijData, this.env, this.activeDelPackageNames, this.msgBundle, this.cssRenamingMap);
        renderVisitor.visitChildren(blockNode);
        return StringData.forValue(stringBuilder.toString());
    }

    private class PluralSelectMsgPartsVisitor {
        private final MsgNode msgNode;
        private final ULocale locale;
        private int currentPluralRemainderValue;

        public PluralSelectMsgPartsVisitor(MsgNode msgNode, ULocale uLocale) {
            this.msgNode = msgNode;
            this.locale = uLocale;
        }

        private void visitPart(SoyMsgSelectPart soyMsgSelectPart) {
            String string;
            String string2 = soyMsgSelectPart.getSelectVarName();
            MsgSelectNode msgSelectNode = this.msgNode.getRepSelectNode(string2);
            ExprRootNode<?> exprRootNode = msgSelectNode.getExpr();
            try {
                string = RenderVisitor.this.eval(exprRootNode).stringValue();
            }
            catch (SoyDataException soyDataException) {
                throw new RenderException(String.format("Select expression \"%s\" doesn't evaluate to string.", exprRootNode.toSourceString()));
            }
            List list = null;
            List list2 = null;
            for (Pair<String, List<SoyMsgPart>> object : soyMsgSelectPart.getCases()) {
                if (object.first == null) {
                    list2 = (List)object.second;
                    continue;
                }
                if (!((String)object.first).equals(string)) continue;
                list = (List)object.second;
                break;
            }
            if (list == null) {
                list = list2;
            }
            if (list != null) {
                for (SoyMsgPart soyMsgPart : list) {
                    if (soyMsgPart instanceof SoyMsgSelectPart) {
                        this.visitPart((SoyMsgSelectPart)soyMsgPart);
                        continue;
                    }
                    if (soyMsgPart instanceof SoyMsgPluralPart) {
                        this.visitPart((SoyMsgPluralPart)soyMsgPart);
                        continue;
                    }
                    if (soyMsgPart instanceof SoyMsgPlaceholderPart) {
                        this.visitPart((SoyMsgPlaceholderPart)soyMsgPart);
                        continue;
                    }
                    if (soyMsgPart instanceof SoyMsgRawTextPart) {
                        this.visitPart((SoyMsgRawTextPart)soyMsgPart);
                        continue;
                    }
                    throw new RenderException("Unsupported part of type " + soyMsgPart.getClass().getName() + " under a select case.");
                }
            }
        }

        private void visitPart(SoyMsgPluralPart soyMsgPluralPart) {
            int n;
            MsgPluralNode msgPluralNode = this.msgNode.getRepPluralNode(soyMsgPluralPart.getPluralVarName());
            ExprRootNode<?> exprRootNode = msgPluralNode.getExpr();
            try {
                n = RenderVisitor.this.eval(exprRootNode).integerValue();
            }
            catch (SoyDataException soyDataException) {
                throw new RenderException(String.format("Plural expression \"%s\" doesn't evaluate to integer.", exprRootNode.toSourceString()));
            }
            this.currentPluralRemainderValue = n - msgPluralNode.getOffset();
            List list = null;
            boolean bl = false;
            List list2 = null;
            for (Pair<SoyMsgPluralCaseSpec, List<SoyMsgPart>> object : soyMsgPluralPart.getCases()) {
                SoyMsgPluralCaseSpec soyMsgPluralCaseSpec = (SoyMsgPluralCaseSpec)object.first;
                SoyMsgPluralCaseSpec.Type type = soyMsgPluralCaseSpec.getType();
                if (type == SoyMsgPluralCaseSpec.Type.EXPLICIT) {
                    if (soyMsgPluralCaseSpec.getExplicitValue() != n) continue;
                    list = (List)object.second;
                    break;
                }
                if (type == SoyMsgPluralCaseSpec.Type.OTHER) {
                    list2 = (List)object.second;
                    continue;
                }
                bl = true;
            }
            if (list == null && !bl) {
                list = list2;
            }
            if (list == null) {
                String string = PluralRules.forLocale((ULocale)this.locale).select((double)this.currentPluralRemainderValue);
                SoyMsgPluralCaseSpec.Type type = new SoyMsgPluralCaseSpec(string).getType();
                for (Pair pair : soyMsgPluralPart.getCases()) {
                    if (((SoyMsgPluralCaseSpec)pair.first).getType() != type) continue;
                    list = (List)pair.second;
                    break;
                }
            }
            if (list != null) {
                for (SoyMsgPart soyMsgPart : list) {
                    if (soyMsgPart instanceof SoyMsgPlaceholderPart) {
                        this.visitPart((SoyMsgPlaceholderPart)soyMsgPart);
                        continue;
                    }
                    if (soyMsgPart instanceof SoyMsgRawTextPart) {
                        this.visitPart((SoyMsgRawTextPart)soyMsgPart);
                        continue;
                    }
                    if (soyMsgPart instanceof SoyMsgPluralRemainderPart) {
                        this.visitPart((SoyMsgPluralRemainderPart)soyMsgPart);
                        continue;
                    }
                    throw new RenderException("Unsupported part of type " + soyMsgPart.getClass().getName() + " under a plural case.");
                }
            }
        }

        private void visitPart(SoyMsgPluralRemainderPart soyMsgPluralRemainderPart) {
            RenderVisitor.this.outputSb.append(this.currentPluralRemainderValue);
        }

        private void visitPart(SoyMsgPlaceholderPart soyMsgPlaceholderPart) {
            RenderVisitor.this.visit(this.msgNode.getRepPlaceholderNode(soyMsgPlaceholderPart.getPlaceholderName()));
        }

        private void visitPart(SoyMsgRawTextPart soyMsgRawTextPart) {
            RenderVisitor.this.outputSb.append(soyMsgRawTextPart.getRawText());
        }
    }

    public static interface RenderVisitorFactory {
        public RenderVisitor create(StringBuilder var1, TemplateRegistry var2, @Nullable SoyMapData var3, @Nullable SoyMapData var4, @Nullable Deque<Map<String, SoyData>> var5, @Nullable Set<String> var6, @Nullable SoyMsgBundle var7, @Nullable SoyCssRenamingMap var8);
    }
}

