/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.base.IncrementingIdGenerator;
import com.google.template.soy.base.SoyFileSupplier;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.parsepasses.CheckDelegatesVisitor;
import com.google.template.soy.parsepasses.CheckOverridesVisitor;
import com.google.template.soy.parsepasses.PrependNamespacesToCalleeNamesVisitor;
import com.google.template.soy.parsepasses.RewriteRemainderNodesVisitor;
import com.google.template.soy.parsepasses.VerifyPhnameAttrOnlyOnPlaceholdersVisitor;
import com.google.template.soy.sharedpasses.AssertSyntaxVersionV2Visitor;
import com.google.template.soy.sharedpasses.CheckSoyDocVisitor;
import com.google.template.soy.sharedpasses.RemoveHtmlCommentsVisitor;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class SoyFileSetParser {
    private final List<SoyFileSupplier> soyFileSuppliers;
    private boolean doRunInitialParsingPasses;
    private boolean doRunCheckingPasses;
    private boolean doEnforceSyntaxVersionV2;
    private boolean doCheckOverrides;

    public SoyFileSetParser(SoyFileSupplier ... soyFileSupplierArray) {
        this(Lists.newArrayList((Object[])soyFileSupplierArray));
    }

    public SoyFileSetParser(List<SoyFileSupplier> list) {
        this.soyFileSuppliers = list;
        this.doRunInitialParsingPasses = true;
        this.doRunCheckingPasses = true;
        this.doEnforceSyntaxVersionV2 = true;
        this.doCheckOverrides = true;
    }

    public SoyFileSetParser setDoRunInitialParsingPasses(boolean bl) {
        this.doRunInitialParsingPasses = bl;
        if (!bl) {
            this.doRunCheckingPasses = false;
            this.doEnforceSyntaxVersionV2 = false;
            this.doCheckOverrides = false;
        }
        return this;
    }

    public SoyFileSetParser setDoRunCheckingPasses(boolean bl) {
        this.doRunCheckingPasses = bl;
        if (bl) {
            Preconditions.checkState((boolean)this.doRunInitialParsingPasses);
        } else {
            this.doEnforceSyntaxVersionV2 = false;
            this.doCheckOverrides = false;
        }
        return this;
    }

    public SoyFileSetParser setDoEnforceSyntaxVersionV2(boolean bl) {
        this.doEnforceSyntaxVersionV2 = bl;
        if (bl) {
            Preconditions.checkState((boolean)this.doRunCheckingPasses);
        }
        return this;
    }

    public SoyFileSetParser setDoCheckOverrides(boolean bl) {
        this.doCheckOverrides = bl;
        if (bl) {
            Preconditions.checkState((boolean)this.doRunCheckingPasses);
        }
        return this;
    }

    public SoyFileSetNode parse() throws SoySyntaxException {
        return (SoyFileSetNode)this.parseWithVersions().first;
    }

    public Pair<SoyFileSetNode, List<SoyFileSupplier.Version>> parseWithVersions() throws SoySyntaxException {
        IncrementingIdGenerator incrementingIdGenerator = new IncrementingIdGenerator();
        SoyFileSetNode soyFileSetNode = new SoyFileSetNode(incrementingIdGenerator.genId(), incrementingIdGenerator);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SoyFileSupplier soyFileSupplier : this.soyFileSuppliers) {
            Pair<SoyFileNode, SoyFileSupplier.Version> pair = SoyFileSetParser.parseSoyFileHelper(soyFileSupplier, incrementingIdGenerator, soyFileSupplier.getPath());
            soyFileSetNode.addChild((SoyNode)pair.first);
            builder.add(pair.second);
        }
        if (this.doRunInitialParsingPasses) {
            new RewriteRemainderNodesVisitor().exec(soyFileSetNode);
            new PrependNamespacesToCalleeNamesVisitor().exec(soyFileSetNode);
            if (this.doRunCheckingPasses) {
                this.runCheckingPasses(soyFileSetNode);
            }
        }
        return Pair.of(soyFileSetNode, builder.build());
    }

    private static Pair<SoyFileNode, SoyFileSupplier.Version> parseSoyFileHelper(SoyFileSupplier soyFileSupplier, IdGenerator idGenerator, String string) throws SoySyntaxException {
        SoyFileSupplier.Version version;
        Reader reader;
        Object object;
        try {
            object = soyFileSupplier.open();
            reader = (Reader)((Pair)object).first;
            version = (SoyFileSupplier.Version)((Pair)object).second;
        }
        catch (IOException iOException) {
            throw new SoySyntaxException("Error opening Soy file " + soyFileSupplier.getPath() + ": " + iOException);
        }
        try {
            object = new SoyFileParser(reader, idGenerator, string).parseSoyFile();
            ((SoyFileNode)object).setFilePath(soyFileSupplier.getPath());
            if (soyFileSupplier.hasChangedSince(version)) {
                throw new SoySyntaxException("Version skew in Soy file " + soyFileSupplier.getPath());
            }
            Pair<Object, SoyFileSupplier.Version> pair = Pair.of(object, version);
            return pair;
        }
        catch (TokenMgrError tokenMgrError) {
            throw new SoySyntaxException(tokenMgrError).setFilePath(soyFileSupplier.getPath());
        }
        catch (ParseException parseException) {
            throw new SoySyntaxException(parseException).setFilePath(soyFileSupplier.getPath());
        }
        catch (SoySyntaxException soySyntaxException) {
            throw soySyntaxException.setFilePath(soyFileSupplier.getPath());
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                throw new SoySyntaxException("Error closing Soy file " + soyFileSupplier.getPath() + ": " + iOException);
            }
        }
    }

    private void runCheckingPasses(SoyFileSetNode soyFileSetNode) {
        if (this.doEnforceSyntaxVersionV2) {
            new AssertSyntaxVersionV2Visitor().exec(soyFileSetNode);
        } else {
            new RemoveHtmlCommentsVisitor().exec(soyFileSetNode);
        }
        new VerifyPhnameAttrOnlyOnPlaceholdersVisitor().exec(soyFileSetNode);
        new CheckSoyDocVisitor(this.doEnforceSyntaxVersionV2).exec(soyFileSetNode);
        if (this.doCheckOverrides) {
            new CheckOverridesVisitor().exec(soyFileSetNode);
        }
        new CheckDelegatesVisitor().exec(soyFileSetNode);
    }
}

