/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.SimpleCharStream;
import com.google.template.soy.soyparse.TemplateParserConstants;
import com.google.template.soy.soyparse.TemplateParserTokenManager;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateParser
implements TemplateParserConstants {
    private static final String LINE_BOUNDARY_REGEX = "\\s*?(\\n|\\r)\\s*";
    private static final Pattern LINE_BOUNDARY_PATTERN = Pattern.compile("\\s*?(\\n|\\r)\\s*");
    private static final Pattern START_EDGE_LINE_BOUNDARY_PATTERN = Pattern.compile("^\\s*?(\\n|\\r)\\s*");
    private static final Pattern END_EDGE_LINE_BOUNDARY_PATTERN = Pattern.compile("\\s*?(\\n|\\r)\\s*$");
    private static final Pattern NONEDGE_LINE_BOUNDARY_PATTERN = Pattern.compile("(?<=\\S)\\s*?(\\n|\\r)\\s*(?=\\S)");
    private IdGenerator nodeIdGen;
    private String sourcePath = SourceLocation.UNKNOWN.getSourcePath();
    private int lineNumOffset;
    private static final Map<String, String> SPECIAL_CHAR_CMD_NAME_TO_RAW_TEXT = ImmutableMap.builder().put((Object)"sp", (Object)" ").put((Object)"nil", (Object)"").put((Object)"\\n", (Object)"\n").put((Object)"\\r", (Object)"\r").put((Object)"\\t", (Object)"\t").put((Object)"lb", (Object)"{").put((Object)"rb", (Object)"}").build();
    public TemplateParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[19];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[36];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public TemplateParser(Reader reader, IdGenerator idGenerator) {
        this(reader);
        this.nodeIdGen = idGenerator;
    }

    public TemplateParser(String string, String string2, int n, IdGenerator idGenerator) {
        this(new StringReader(string), idGenerator);
        this.sourcePath = string2;
        this.lineNumOffset = n - 1;
    }

    public List<SoyNode.StandaloneNode> parseTemplateBody() throws SoySyntaxException, TokenMgrError, ParseException {
        Preconditions.checkNotNull((Object)this.nodeIdGen);
        return this.TemplateBodyInput();
    }

    private <T extends SoyNode> T setLocation(T t, int n) {
        t.setLocation(new SourceLocation(this.sourcePath, n + this.lineNumOffset));
        return t;
    }

    private final SourceItemInfo<Void> SoyTagOpen() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                token = this.jj_consume_token(5);
                break;
            }
            case 6: {
                token = this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SourceItemInfo<Object>(null, token.beginLine);
    }

    private final void RegSoyTagClose() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final void SelfEndingSoyTagClose() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final String CmdText() throws ParseException {
        List<String> list = this.CmdTextParts();
        return Joiner.on((String)"").join(list);
    }

    private final List<String> CmdTextParts() throws ParseException {
        StringBuilder stringBuilder;
        ArrayList arrayList;
        block21: {
            arrayList = Lists.newArrayList();
            stringBuilder = new StringBuilder();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    String string = this.AnyCmdName();
                    stringBuilder.append(string);
                    this.jj_consume_token(55);
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                }
            }
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 56: 
                    case 57: 
                    case 59: 
                    case 60: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        break block21;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 59: {
                        Token token = this.jj_consume_token(59);
                        stringBuilder.append(token.image);
                        continue block15;
                    }
                    case 60: {
                        Token token = this.jj_consume_token(60);
                        stringBuilder.append(token.image);
                        continue block15;
                    }
                    case 56: 
                    case 57: {
                        Token token;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 56: {
                                token = this.jj_consume_token(56);
                                break;
                            }
                            case 57: {
                                token = this.jj_consume_token(57);
                                break;
                            }
                            default: {
                                this.jj_la1[5] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (stringBuilder.length() > 0) {
                            arrayList.add(stringBuilder.toString());
                            stringBuilder = new StringBuilder();
                        }
                        arrayList.add(token.image);
                        continue block15;
                    }
                }
                break;
            }
            this.jj_la1[6] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
            stringBuilder = new StringBuilder();
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            if (i == 0) {
                string = CharMatcher.WHITESPACE.trimLeadingFrom((CharSequence)string);
            }
            if (i == n - 1) {
                string = CharMatcher.WHITESPACE.trimTrailingFrom((CharSequence)string);
            }
            string = LINE_BOUNDARY_PATTERN.matcher(string).replaceAll(" ");
            arrayList.set(i, string);
        }
        return arrayList;
    }

    private final String AnyCmdName() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                token = this.jj_consume_token(9);
                break;
            }
            case 10: {
                token = this.jj_consume_token(10);
                break;
            }
            case 11: {
                token = this.jj_consume_token(11);
                break;
            }
            case 12: {
                token = this.jj_consume_token(12);
                break;
            }
            case 13: {
                token = this.jj_consume_token(13);
                break;
            }
            case 14: {
                token = this.jj_consume_token(14);
                break;
            }
            case 15: {
                token = this.jj_consume_token(15);
                break;
            }
            case 16: {
                token = this.jj_consume_token(16);
                break;
            }
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            case 18: {
                token = this.jj_consume_token(18);
                break;
            }
            case 19: {
                token = this.jj_consume_token(19);
                break;
            }
            case 24: {
                token = this.jj_consume_token(24);
                break;
            }
            case 25: {
                token = this.jj_consume_token(25);
                break;
            }
            case 26: {
                token = this.jj_consume_token(26);
                break;
            }
            case 27: {
                token = this.jj_consume_token(27);
                break;
            }
            case 28: {
                token = this.jj_consume_token(28);
                break;
            }
            case 29: {
                token = this.jj_consume_token(29);
                break;
            }
            case 30: {
                token = this.jj_consume_token(30);
                break;
            }
            case 31: {
                token = this.jj_consume_token(31);
                break;
            }
            case 32: {
                token = this.jj_consume_token(32);
                break;
            }
            case 43: {
                token = this.jj_consume_token(43);
                break;
            }
            case 44: {
                token = this.jj_consume_token(44);
                break;
            }
            case 33: {
                token = this.jj_consume_token(33);
                break;
            }
            case 34: {
                token = this.jj_consume_token(34);
                break;
            }
            case 35: {
                token = this.jj_consume_token(35);
                break;
            }
            case 36: {
                token = this.jj_consume_token(36);
                break;
            }
            case 37: {
                token = this.jj_consume_token(37);
                break;
            }
            case 38: {
                token = this.jj_consume_token(38);
                break;
            }
            case 39: {
                token = this.jj_consume_token(39);
                break;
            }
            case 40: {
                token = this.jj_consume_token(40);
                break;
            }
            case 41: {
                token = this.jj_consume_token(41);
                break;
            }
            case 42: {
                token = this.jj_consume_token(42);
                break;
            }
            case 45: {
                token = this.jj_consume_token(45);
                break;
            }
            case 46: {
                token = this.jj_consume_token(46);
                break;
            }
            case 47: {
                token = this.jj_consume_token(47);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token.image;
    }

    private final SourceItemInfo<String> BasicRawText() throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        Token token = this.jj_consume_token(75);
        stringBuilder.append(token.image);
        boolean bl = token.beginLine == 1 && token.beginColumn == 1;
        int n = token.beginLine;
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            token = this.jj_consume_token(75);
            stringBuilder.append(token.image);
        }
        String string = stringBuilder.toString();
        if (bl) {
            string = CharMatcher.WHITESPACE.trimLeadingFrom((CharSequence)string);
        }
        string = START_EDGE_LINE_BOUNDARY_PATTERN.matcher(string).replaceFirst("");
        int n2 = stringBuilder.length() - string.length();
        for (int i = 0; i < n2; ++i) {
            char c = stringBuilder.charAt(i);
            if (c == '\r') {
                if (i + 1 != n2 && stringBuilder.charAt(i + 1) == '\n') continue;
                ++n;
                continue;
            }
            if (c != '\n') continue;
            ++n;
        }
        string = END_EDGE_LINE_BOUNDARY_PATTERN.matcher(string).replaceFirst("");
        Matcher matcher = NONEDGE_LINE_BOUNDARY_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (matcher.find()) {
            char c = string.charAt(matcher.start() - 1);
            char c2 = string.charAt(matcher.end());
            matcher.appendReplacement(stringBuffer, c == '>' || c2 == '<' ? "" : " ");
        }
        matcher.appendTail(stringBuffer);
        return new SourceItemInfo<String>(stringBuffer.toString(), n);
    }

    private final void MaybeWhitespace(String string) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 75: {
                SourceItemInfo<String> sourceItemInfo = this.BasicRawText();
                if (((String)sourceItemInfo.parsedContent).trim().length() == 0) break;
                throw new ParseException(string);
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
    }

    private final SourceItemInfo<String> LiteralRawText() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(16);
        this.RegSoyTagClose();
        Token token = this.jj_consume_token(72);
        return new SourceItemInfo<String>(token.image, sourceItemInfo.lineNum);
    }

    private final SourceItemInfo<String> SpecialCharRawText() throws ParseException {
        this.SoyTagOpen();
        SourceItemInfo<String> sourceItemInfo = this.SpecialCharCmdName();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(SPECIAL_CHAR_CMD_NAME_TO_RAW_TEXT.get(sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
    }

    private final SourceItemInfo<String> SpecialCharCmdName() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                token = this.jj_consume_token(9);
                break;
            }
            case 10: {
                token = this.jj_consume_token(10);
                break;
            }
            case 11: {
                token = this.jj_consume_token(11);
                break;
            }
            case 12: {
                token = this.jj_consume_token(12);
                break;
            }
            case 13: {
                token = this.jj_consume_token(13);
                break;
            }
            case 14: {
                token = this.jj_consume_token(14);
                break;
            }
            case 15: {
                token = this.jj_consume_token(15);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SourceItemInfo<String>(token.image, token.beginLine);
    }

    private final SourceItemInfo<String> MsgTag() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(18);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final void EndMsgTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(19);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> PluralTag() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(20);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final void EndPluralTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(21);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> SelectTag() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(22);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final void EndSelectTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(23);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<List<String>> PrintTag() throws ParseException {
        ArrayList arrayList = Lists.newArrayList();
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.jj_consume_token(24);
            this.jj_consume_token(54);
            arrayList.add("print");
        }
        List<String> list = this.CmdTextParts();
        arrayList.addAll(list);
        this.RegSoyTagClose();
        return new SourceItemInfo<List<String>>(arrayList, sourceItemInfo.lineNum);
    }

    private final SourceItemInfo<String> CssTag() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(25);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final SourceItemInfo<String> LetTagSelfEnding() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(26);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.SelfEndingSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final SourceItemInfo<String> LetTagNotSelfEnding() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(26);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final void EndLetTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(27);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> IfTag() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(28);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final SourceItemInfo<String> ElseifTag() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(29);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final SourceItemInfo<Void> ElseTag() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(30);
        this.RegSoyTagClose();
        return sourceItemInfo;
    }

    private final void EndIfTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(31);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> SwitchTag() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(32);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final void EndSwitchTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(33);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> ForeachTag() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(34);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final SourceItemInfo<Void> IfemptyTag() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(35);
        this.RegSoyTagClose();
        return sourceItemInfo;
    }

    private final void EndForeachTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(36);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> ForTag() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(37);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final void EndForTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(38);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<List<String>> AnyCallTagSelfEnding() throws ParseException {
        ArrayList arrayList = Lists.newArrayList();
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        Token token = this.jj_consume_token(39);
        arrayList.add(token.image);
        this.jj_consume_token(54);
        List<String> list = this.CmdTextParts();
        arrayList.addAll(list);
        this.SelfEndingSoyTagClose();
        return new SourceItemInfo<List<String>>(arrayList, sourceItemInfo.lineNum);
    }

    private final SourceItemInfo<List<String>> AnyCallTagNotSelfEnding() throws ParseException {
        ArrayList arrayList = Lists.newArrayList();
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        Token token = this.jj_consume_token(39);
        arrayList.add(token.image);
        this.jj_consume_token(54);
        List<String> list = this.CmdTextParts();
        arrayList.addAll(list);
        this.RegSoyTagClose();
        return new SourceItemInfo<List<String>>(arrayList, sourceItemInfo.lineNum);
    }

    private final boolean EndAnyCallTag() throws ParseException {
        this.SoyTagOpen();
        Token token = this.jj_consume_token(40);
        this.RegSoyTagClose();
        return token.image.equals("/call");
    }

    private final SourceItemInfo<String> ParamTagSelfEnding() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(41);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.SelfEndingSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final SourceItemInfo<String> ParamTagNotSelfEnding() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(41);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final void EndParamTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(42);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> CaseTag() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(43);
        this.jj_consume_token(54);
        String string = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(string, sourceItemInfo.lineNum);
    }

    private final SourceItemInfo<Void> DefaultTag() throws ParseException {
        SourceItemInfo<Void> sourceItemInfo = this.SoyTagOpen();
        this.jj_consume_token(44);
        this.RegSoyTagClose();
        return sourceItemInfo;
    }

    private final List<SoyNode.StandaloneNode> TemplateBodyInput() throws ParseException, SoySyntaxException {
        List<SoyNode.StandaloneNode> list = this.TemplateBlock();
        this.jj_consume_token(0);
        if (this.token_source.curLexState == 2) {
            throw new ParseException("At end of template, found comment block that is never closed.");
        }
        return list;
    }

    private final List<SoyNode.StandaloneNode> TemplateBlock() throws ParseException, SoySyntaxException {
        ArrayList arrayList = Lists.newArrayList();
        block3: while (this.jj_2_3(Integer.MAX_VALUE)) {
            if (this.jj_2_4(Integer.MAX_VALUE)) {
                RawTextNode rawTextNode = this.ContiguousRawText();
                if (rawTextNode == null) continue;
                arrayList.add(rawTextNode);
                continue;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 6: {
                    SoyNode.StatementNode statementNode = this.Stmt();
                    arrayList.add(statementNode);
                    continue block3;
                }
            }
            this.jj_la1[10] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return arrayList;
    }

    private final RawTextNode ContiguousRawText() throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        block6: do {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 75: {
                    SourceItemInfo<String> sourceItemInfo = this.BasicRawText();
                    if (((String)sourceItemInfo.parsedContent).length() == 0) continue block6;
                    if (n == -1) {
                        n = sourceItemInfo.lineNum;
                    }
                    stringBuilder.append((String)sourceItemInfo.parsedContent);
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    if (this.jj_2_5(Integer.MAX_VALUE)) {
                        SourceItemInfo<String> sourceItemInfo = this.LiteralRawText();
                        if (n == -1) {
                            n = sourceItemInfo.lineNum;
                        }
                        stringBuilder.append((String)sourceItemInfo.parsedContent);
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 6: {
                            SourceItemInfo<String> sourceItemInfo = this.SpecialCharRawText();
                            if (n == -1) {
                                n = sourceItemInfo.lineNum;
                            }
                            stringBuilder.append((String)sourceItemInfo.parsedContent);
                            break block0;
                        }
                    }
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        } while (this.jj_2_6(Integer.MAX_VALUE));
        return stringBuilder.length() > 0 ? this.setLocation(new RawTextNode(this.nodeIdGen.genId(), stringBuilder.toString()), n) : null;
    }

    private final void ContiguousRawTextLookaheadHelper() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                if (this.jj_2_7(Integer.MAX_VALUE)) {
                    this.SoyTagOpen();
                    this.jj_consume_token(16);
                    this.RegSoyTagClose();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: {
                        this.SpecialCharRawText();
                        break block0;
                    }
                }
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final SoyNode.StatementNode Stmt() throws ParseException, SoySyntaxException {
        AbstractSoyNode abstractSoyNode;
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            abstractSoyNode = this.MsgStmt();
        } else if (this.jj_2_9(Integer.MAX_VALUE)) {
            abstractSoyNode = this.PrintStmt();
        } else if (this.jj_2_10(Integer.MAX_VALUE)) {
            abstractSoyNode = this.CssStmt();
        } else if (this.jj_2_11(Integer.MAX_VALUE)) {
            abstractSoyNode = this.LetStmt();
        } else if (this.jj_2_12(Integer.MAX_VALUE)) {
            abstractSoyNode = this.IfStmt();
        } else if (this.jj_2_13(Integer.MAX_VALUE)) {
            abstractSoyNode = this.SwitchStmt();
        } else if (this.jj_2_14(Integer.MAX_VALUE)) {
            abstractSoyNode = this.ForeachStmt();
        } else if (this.jj_2_15(Integer.MAX_VALUE)) {
            abstractSoyNode = this.ForStmt();
        } else if (this.jj_2_16(Integer.MAX_VALUE)) {
            abstractSoyNode = this.CallStmt();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return abstractSoyNode;
    }

    private final void StmtLookaheadHelper() throws ParseException {
        if (this.jj_2_17(Integer.MAX_VALUE)) {
            this.PrintStmtLookaheadHelper();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 6: {
                    this.SoyTagOpen();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 18: {
                            this.jj_consume_token(18);
                            break;
                        }
                        case 25: {
                            this.jj_consume_token(25);
                            break;
                        }
                        case 26: {
                            this.jj_consume_token(26);
                            break;
                        }
                        case 28: {
                            this.jj_consume_token(28);
                            break;
                        }
                        case 32: {
                            this.jj_consume_token(32);
                            break;
                        }
                        case 34: {
                            this.jj_consume_token(34);
                            break;
                        }
                        case 37: {
                            this.jj_consume_token(37);
                            break;
                        }
                        case 39: {
                            this.jj_consume_token(39);
                            break;
                        }
                        default: {
                            this.jj_la1[15] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(54);
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    private final MsgNode MsgStmt() throws ParseException, SoySyntaxException {
        SourceItemInfo<String> sourceItemInfo = this.MsgTag();
        MsgNode msgNode = this.setLocation(new MsgNode(this.nodeIdGen.genId(), (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
        List<SoyNode.StandaloneNode> list = this.TemplateBlockForMsg();
        msgNode.addChildren(list);
        this.EndMsgTag();
        return msgNode;
    }

    private final List<SoyNode.StandaloneNode> TemplateBlockForMsg() throws ParseException, SoySyntaxException {
        ArrayList arrayList = Lists.newArrayList();
        if (this.jj_2_20(Integer.MAX_VALUE)) {
            this.MaybeWhitespace("No message content is allowed before a 'plural' block.");
            MsgPluralNode msgPluralNode = this.MsgPlural();
            arrayList.add(msgPluralNode);
            this.MaybeWhitespace("No message content is allowed after a 'plural' block.");
        } else if (this.jj_2_21(Integer.MAX_VALUE)) {
            this.MaybeWhitespace("No message content is allowed before a 'select' block.");
            MsgSelectNode msgSelectNode = this.MsgSelect();
            arrayList.add(msgSelectNode);
            this.MaybeWhitespace("No message content is allowed after a 'select' block.");
        } else {
            block4: while (this.jj_2_18(Integer.MAX_VALUE)) {
                if (this.jj_2_19(Integer.MAX_VALUE)) {
                    RawTextNode rawTextNode = this.ContiguousRawText();
                    if (rawTextNode == null) continue;
                    arrayList.add(rawTextNode);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: {
                        SoyNode.StatementNode statementNode = this.Stmt();
                        if (!(statementNode instanceof SoyNode.MsgPlaceholderInitialContentNode)) {
                            String string = statementNode instanceof IfNode ? "if" : ((SoyNode.CommandNode)((Object)statementNode)).getCommandName();
                            throw new SoySyntaxException("Command '" + string + "' not allowed within a 'msg' block.");
                        }
                        arrayList.add(new MsgPlaceholderNode(this.nodeIdGen.genId(), (SoyNode.MsgPlaceholderInitialContentNode)((Object)statementNode)));
                        continue block4;
                    }
                    case 69: {
                        MsgHtmlTagNode msgHtmlTagNode = this.MsgHtmlTag();
                        arrayList.add(new MsgPlaceholderNode(this.nodeIdGen.genId(), msgHtmlTagNode));
                        continue block4;
                    }
                }
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return arrayList;
    }

    private final MsgPluralNode MsgPlural() throws ParseException, SoySyntaxException {
        List<SoyNode.StandaloneNode> list;
        CaseOrDefaultNode caseOrDefaultNode;
        SourceItemInfo<String> sourceItemInfo = this.PluralTag();
        MsgPluralNode msgPluralNode = this.setLocation(new MsgPluralNode(this.nodeIdGen.genId(), (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
        this.MaybeWhitespace("No content allowed between 'plural' and 'case' (whitespace and comments are okay).");
        while (this.jj_2_22(Integer.MAX_VALUE)) {
            sourceItemInfo = this.CaseTag();
            caseOrDefaultNode = this.setLocation(new MsgPluralCaseNode(this.nodeIdGen.genId(), (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
            msgPluralNode.addChild(caseOrDefaultNode);
            list = this.TemplateBlockForMsg();
            if (list.size() == 1 && (list.get(0) instanceof MsgPluralNode || list.get(0) instanceof MsgSelectNode)) {
                throw new SoySyntaxException("Tags 'plural' and 'select' are not allowed inside 'plural' blocks.");
            }
            caseOrDefaultNode.addChildren(list);
        }
        SourceItemInfo<Void> sourceItemInfo2 = this.DefaultTag();
        caseOrDefaultNode = this.setLocation(new MsgPluralDefaultNode(this.nodeIdGen.genId()), sourceItemInfo2.lineNum);
        msgPluralNode.addChild(caseOrDefaultNode);
        list = this.TemplateBlockForMsg();
        if (list.size() == 1 && (list.get(0) instanceof MsgPluralNode || list.get(0) instanceof MsgSelectNode)) {
            throw new SoySyntaxException("Tags 'plural' and 'select' are not allowed inside 'plural' blocks.");
        }
        caseOrDefaultNode.addChildren(list);
        this.EndPluralTag();
        return msgPluralNode;
    }

    private final MsgSelectNode MsgSelect() throws ParseException, SoySyntaxException {
        List<SoyNode.StandaloneNode> list;
        CaseOrDefaultNode caseOrDefaultNode;
        SourceItemInfo<String> sourceItemInfo = this.SelectTag();
        MsgSelectNode msgSelectNode = this.setLocation(new MsgSelectNode(this.nodeIdGen.genId(), (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
        this.MaybeWhitespace("No content allowed between 'select' and 'case' (whitespace and comments are okay).");
        while (this.jj_2_23(Integer.MAX_VALUE)) {
            sourceItemInfo = this.CaseTag();
            caseOrDefaultNode = this.setLocation(new MsgSelectCaseNode(this.nodeIdGen.genId(), (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
            msgSelectNode.addChild(caseOrDefaultNode);
            list = this.TemplateBlockForMsg();
            caseOrDefaultNode.addChildren(list);
        }
        SourceItemInfo<Void> sourceItemInfo2 = this.DefaultTag();
        caseOrDefaultNode = this.setLocation(new MsgSelectDefaultNode(this.nodeIdGen.genId()), sourceItemInfo2.lineNum);
        msgSelectNode.addChild(caseOrDefaultNode);
        list = this.TemplateBlockForMsg();
        caseOrDefaultNode.addChildren(list);
        this.EndSelectTag();
        return msgSelectNode;
    }

    private final MsgHtmlTagNode MsgHtmlTag() throws ParseException, SoySyntaxException {
        RawTextNode rawTextNode;
        Token token = this.jj_consume_token(69);
        List<SoyNode.StandaloneNode> list = this.TemplateBlock();
        this.jj_consume_token(70);
        int n = token.beginLine;
        if (list.get(0) instanceof RawTextNode) {
            RawTextNode rawTextNode2 = (RawTextNode)list.get(0);
            rawTextNode = new RawTextNode(this.nodeIdGen.genId(), "<" + rawTextNode2.getRawText());
            list.set(0, this.setLocation(rawTextNode, n));
        } else {
            list.add(0, this.setLocation(new RawTextNode(this.nodeIdGen.genId(), "<"), n));
        }
        int n2 = list.size() - 1;
        if (list.get(n2) instanceof RawTextNode) {
            rawTextNode = (RawTextNode)list.get(n2);
            RawTextNode rawTextNode3 = new RawTextNode(this.nodeIdGen.genId(), rawTextNode.getRawText() + ">");
            list.set(n2, this.setLocation(rawTextNode3, n));
        } else {
            list.add(this.setLocation(new RawTextNode(this.nodeIdGen.genId(), ">"), n));
        }
        return this.setLocation(new MsgHtmlTagNode(this.nodeIdGen.genId(), list), n);
    }

    private final PrintNode PrintStmt() throws ParseException, SoySyntaxException {
        Object object;
        String string4;
        List list;
        boolean bl;
        SourceItemInfo<List<String>> sourceItemInfo = this.PrintTag();
        int n = sourceItemInfo.lineNum;
        if (!((List)sourceItemInfo.parsedContent).isEmpty() && ((String)((List)sourceItemInfo.parsedContent).get(0)).equals("print")) {
            bl = false;
            list = ((List)sourceItemInfo.parsedContent).subList(1, ((List)sourceItemInfo.parsedContent).size());
        } else {
            bl = true;
            list = (List)sourceItemInfo.parsedContent;
        }
        String string2 = Joiner.on((String)"").join((Iterable)list);
        String string3 = null;
        for (String string4 : list) {
            if (!string4.startsWith(" phname=\"") || !string4.endsWith("\"")) continue;
            if (string3 != null) {
                throw new SoySyntaxException("Found multiple 'phname' attributes in 'print' command text \"" + string2 + "\".");
            }
            string3 = string4;
        }
        if (string3 != null) {
            list.remove(string3);
            object = string3.substring(9, string3.length() - 1);
        } else {
            object = null;
        }
        if (list.isEmpty()) {
            throw new SoySyntaxException("Found 'print' command with empty command text.");
        }
        string4 = ((String)list.get(0)).trim();
        PrintNode printNode = this.setLocation(new PrintNode(this.nodeIdGen.genId(), bl, string4, (String)object), n);
        String string5 = null;
        int n2 = list.size();
        for (int i = 1; i < n2; ++i) {
            String string6 = (String)list.get(i);
            if (string6.startsWith("|")) {
                if (string5 != null) {
                    printNode.addChild(this.setLocation(new PrintDirectiveNode(this.nodeIdGen.genId(), string5, ""), n));
                }
                string5 = string6;
                continue;
            }
            if (string6.startsWith(":")) {
                if (string5 == null) {
                    throw new AssertionError();
                }
                String string7 = string6.substring(1);
                printNode.addChild(this.setLocation(new PrintDirectiveNode(this.nodeIdGen.genId(), string5, string7), n));
                string5 = null;
                continue;
            }
            if (string6.trim().length() == 0) continue;
            throw new SoySyntaxException("Invalid 'print' command text \"" + string2 + "\" (check the directives).");
        }
        if (string5 != null) {
            printNode.addChild(this.setLocation(new PrintDirectiveNode(this.nodeIdGen.genId(), string5, ""), n));
        }
        return printNode;
    }

    private final void PrintStmtLookaheadHelper() throws ParseException {
        this.SoyTagOpen();
        if (this.jj_2_24(Integer.MAX_VALUE)) {
            this.jj_consume_token(24);
            this.jj_consume_token(54);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    this.AnyCmdName();
                    this.jj_consume_token(55);
                    break;
                }
                case 59: {
                    this.jj_consume_token(59);
                    break;
                }
                case 60: {
                    this.jj_consume_token(60);
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    private final CssNode CssStmt() throws ParseException, SoySyntaxException {
        SourceItemInfo<String> sourceItemInfo = this.CssTag();
        return this.setLocation(new CssNode(this.nodeIdGen.genId(), (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
    }

    private final LetNode LetStmt() throws ParseException, SoySyntaxException {
        LetNode letNode;
        if (this.jj_2_25(Integer.MAX_VALUE)) {
            SourceItemInfo<String> sourceItemInfo = this.LetTagSelfEnding();
            letNode = this.setLocation(new LetValueNode(this.nodeIdGen.genId(), false, (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
        } else if (this.jj_2_26(Integer.MAX_VALUE)) {
            SourceItemInfo<String> sourceItemInfo = this.LetTagNotSelfEnding();
            LetContentNode letContentNode = this.setLocation(new LetContentNode(this.nodeIdGen.genId(), false, (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
            List<SoyNode.StandaloneNode> list = this.TemplateBlock();
            letContentNode.addChildren((List<? extends SoyNode.StandaloneNode>)list);
            letNode = letContentNode;
            this.EndLetTag();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return letNode;
    }

    private final IfNode IfStmt() throws ParseException, SoySyntaxException {
        SourceItemInfo<String> sourceItemInfo = this.IfTag();
        IfNode ifNode = this.setLocation(new IfNode(this.nodeIdGen.genId()), sourceItemInfo.lineNum);
        IfCondNode ifCondNode = this.setLocation(new IfCondNode(this.nodeIdGen.genId(), "if", (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
        ifNode.addChild(ifCondNode);
        List<SoyNode.StandaloneNode> list = this.TemplateBlock();
        ifCondNode.addChildren(list);
        while (this.jj_2_27(Integer.MAX_VALUE)) {
            sourceItemInfo = this.ElseifTag();
            ifCondNode = this.setLocation(new IfCondNode(this.nodeIdGen.genId(), "elseif", (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
            ifNode.addChild(ifCondNode);
            list = this.TemplateBlock();
            ifCondNode.addChildren(list);
        }
        if (this.jj_2_28(Integer.MAX_VALUE)) {
            SourceItemInfo<Void> sourceItemInfo2 = this.ElseTag();
            IfElseNode ifElseNode = this.setLocation(new IfElseNode(this.nodeIdGen.genId()), sourceItemInfo2.lineNum);
            ifNode.addChild(ifElseNode);
            list = this.TemplateBlock();
            ifElseNode.addChildren(list);
        }
        this.EndIfTag();
        return ifNode;
    }

    private final SwitchNode SwitchStmt() throws ParseException, SoySyntaxException {
        List<SoyNode.StandaloneNode> list;
        CaseOrDefaultNode caseOrDefaultNode;
        SourceItemInfo<String> sourceItemInfo = this.SwitchTag();
        SwitchNode switchNode = this.setLocation(new SwitchNode(this.nodeIdGen.genId(), (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
        this.MaybeWhitespace("No content allowed between 'switch' and 'case' (whitespace and comments are okay).");
        while (this.jj_2_29(Integer.MAX_VALUE)) {
            sourceItemInfo = this.CaseTag();
            caseOrDefaultNode = this.setLocation(new SwitchCaseNode(this.nodeIdGen.genId(), (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
            switchNode.addChild(caseOrDefaultNode);
            list = this.TemplateBlock();
            caseOrDefaultNode.addChildren(list);
        }
        if (this.jj_2_30(Integer.MAX_VALUE)) {
            SourceItemInfo<Void> sourceItemInfo2 = this.DefaultTag();
            caseOrDefaultNode = this.setLocation(new SwitchDefaultNode(this.nodeIdGen.genId()), sourceItemInfo2.lineNum);
            switchNode.addChild(caseOrDefaultNode);
            list = this.TemplateBlock();
            caseOrDefaultNode.addChildren(list);
        }
        this.EndSwitchTag();
        return switchNode;
    }

    private final ForeachNode ForeachStmt() throws ParseException, SoySyntaxException {
        SourceItemInfo<String> sourceItemInfo = this.ForeachTag();
        ForeachNode foreachNode = this.setLocation(new ForeachNode(this.nodeIdGen.genId(), (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
        int n = this.getToken((int)0).beginLine;
        List<SoyNode.StandaloneNode> list = this.TemplateBlock();
        ForeachNonemptyNode foreachNonemptyNode = this.setLocation(new ForeachNonemptyNode(this.nodeIdGen.genId()), n);
        foreachNode.addChild(foreachNonemptyNode);
        foreachNonemptyNode.addChildren(list);
        if (this.jj_2_31(Integer.MAX_VALUE)) {
            SourceItemInfo<Void> sourceItemInfo2 = this.IfemptyTag();
            list = this.TemplateBlock();
            ForeachIfemptyNode foreachIfemptyNode = this.setLocation(new ForeachIfemptyNode(this.nodeIdGen.genId()), sourceItemInfo2.lineNum);
            foreachNode.addChild(foreachIfemptyNode);
            foreachIfemptyNode.addChildren(list);
        }
        this.EndForeachTag();
        return foreachNode;
    }

    private final ForNode ForStmt() throws ParseException, SoySyntaxException {
        SourceItemInfo<String> sourceItemInfo = this.ForTag();
        ForNode forNode = this.setLocation(new ForNode(this.nodeIdGen.genId(), (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
        List<SoyNode.StandaloneNode> list = this.TemplateBlock();
        forNode.addChildren(list);
        this.EndForTag();
        return forNode;
    }

    private final CallNode CallStmt() throws ParseException, SoySyntaxException {
        Boolean bl;
        SourceItemInfo<List<String>> sourceItemInfo;
        ArrayList arrayList = Lists.newArrayList();
        if (this.jj_2_33(Integer.MAX_VALUE)) {
            sourceItemInfo = this.AnyCallTagSelfEnding();
            bl = null;
        } else if (this.jj_2_34(Integer.MAX_VALUE)) {
            sourceItemInfo = this.AnyCallTagNotSelfEnding();
            this.MaybeWhitespace("No content allowed between 'call' and 'param' (whitespace and comments are okay).");
            while (this.jj_2_32(Integer.MAX_VALUE)) {
                CallParamNode callParamNode = this.CallParam();
                arrayList.add(callParamNode);
                this.MaybeWhitespace("No content allowed between 'param' and 'param' (whitespace and comments are okay).");
            }
            bl = this.EndAnyCallTag();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        List list = (List)sourceItemInfo.parsedContent;
        String string = (String)list.get(0);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        for (int i = 1; i < list.size(); ++i) {
            String string3 = (String)list.get(i);
            if (string3.startsWith(" phname=\"") && string3.endsWith("\"")) {
                if (string2 != null) {
                    throw new SoySyntaxException("Found multiple 'phname' attributes in '" + string + "' command text \"" + Joiner.on((String)"").join(list.subList(1, list.size())) + "\".");
                }
                string2 = string3;
                continue;
            }
            stringBuilder.append(string3);
        }
        String string4 = stringBuilder.toString();
        boolean bl2 = ((String)list.get(0)).equals("call");
        if (bl != null && bl2 != bl) {
            if (bl2) {
                throw new ParseException("Mismatched 'call' and '/delcall'.");
            }
            throw new ParseException("Mismatched 'delcall' and '/call'.");
        }
        String string5 = string2 != null ? string2.substring(9, string2.length() - 1) : null;
        CallNode callNode = bl2 ? new CallBasicNode(this.nodeIdGen.genId(), string4, string5) : new CallDelegateNode(this.nodeIdGen.genId(), string4, string5);
        callNode = this.setLocation(callNode, sourceItemInfo.lineNum);
        callNode.addChildren(arrayList);
        return callNode;
    }

    private final CallParamNode CallParam() throws ParseException, SoySyntaxException {
        CallParamNode callParamNode;
        if (this.jj_2_35(Integer.MAX_VALUE)) {
            SourceItemInfo<String> sourceItemInfo = this.ParamTagSelfEnding();
            callParamNode = this.setLocation(new CallParamValueNode(this.nodeIdGen.genId(), (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
        } else if (this.jj_2_36(Integer.MAX_VALUE)) {
            SourceItemInfo<String> sourceItemInfo = this.ParamTagNotSelfEnding();
            CallParamContentNode callParamContentNode = this.setLocation(new CallParamContentNode(this.nodeIdGen.genId(), (String)sourceItemInfo.parsedContent), sourceItemInfo.lineNum);
            List<SoyNode.StandaloneNode> list = this.TemplateBlock();
            callParamContentNode.addChildren((List<? extends SoyNode.StandaloneNode>)list);
            callParamNode = callParamContentNode;
            this.EndParamTag();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return callParamNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_17(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_18(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_19(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_20(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_21(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_22(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_23(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_24(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_25(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_26(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_27(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_28(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_29(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_30(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_31(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_32(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_33(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_34(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_35(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_36(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, n);
        }
    }

    private final boolean jj_3R_37() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_3R_42()) {
            return true;
        }
        return this.jj_3R_15();
    }

    private final boolean jj_3_33() {
        return this.jj_3R_22();
    }

    private final boolean jj_3_26() {
        return this.jj_3R_21();
    }

    private final boolean jj_3R_20() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        return this.jj_3R_33();
    }

    private final boolean jj_3_25() {
        return this.jj_3R_20();
    }

    private final boolean jj_3R_46() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(56)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(57)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_17() {
        return this.jj_3R_16();
    }

    private final boolean jj_3R_45() {
        return this.jj_scan_token(60);
    }

    private final boolean jj_3R_44() {
        return this.jj_scan_token(59);
    }

    private final boolean jj_3R_41() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_44()) {
            this.jj_scanpos = token;
            if (this.jj_3R_45()) {
                this.jj_scanpos = token;
                if (this.jj_3R_46()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_36() {
        if (this.jj_3R_14()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(18)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(25)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(26)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(28)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(32)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(34)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(37)) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(39)) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_31() {
        return this.jj_3R_39();
    }

    private final boolean jj_3_23() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_35() {
        return this.jj_3R_16();
    }

    private final boolean jj_3R_19() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_26() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_35()) {
            this.jj_scanpos = token;
            if (this.jj_3R_36()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_40() {
        if (this.jj_3R_38()) {
            return true;
        }
        return this.jj_scan_token(55);
    }

    private final boolean jj_3R_34() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_40()) {
            this.jj_scanpos = token;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_41());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3_16() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(39)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3_15() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3_14() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3_24() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3_13() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(32)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3_31() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private final boolean jj_3_12() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_30() {
        if (this.jj_3R_38()) {
            return true;
        }
        return this.jj_scan_token(55);
    }

    private final boolean jj_3_11() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3_10() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_32() {
        return this.jj_3R_34();
    }

    private final boolean jj_3_9() {
        return this.jj_3R_16();
    }

    private final boolean jj_3R_16() {
        if (this.jj_3R_14()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_29()) {
            this.jj_scanpos = token;
            if (this.jj_3R_30()) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(59)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(60)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_33() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(51)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(53)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(62)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(64)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_1() {
        return this.jj_scan_token(75);
    }

    private final boolean jj_3R_25() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        return this.jj_3R_15();
    }

    private final boolean jj_3_22() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3_7() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private final boolean jj_3_36() {
        return this.jj_3R_25();
    }

    private final boolean jj_3R_15() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(50)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(52)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(61)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(63)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_43() {
        return this.jj_scan_token(75);
    }

    private final boolean jj_3_30() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private final boolean jj_3R_28() {
        return this.jj_3R_37();
    }

    private final boolean jj_3R_18() {
        return this.jj_3R_26();
    }

    private final boolean jj_3_35() {
        return this.jj_3R_24();
    }

    private final boolean jj_3R_27() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private final boolean jj_3R_13() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(75)) {
            this.jj_scanpos = token;
            if (this.jj_3R_27()) {
                this.jj_scanpos = token;
                if (this.jj_3R_28()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_24() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        return this.jj_3R_33();
    }

    private final boolean jj_3_29() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_14() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(5)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(6)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_39() {
        Token token;
        if (this.jj_scan_token(75)) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_43());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3_5() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private final boolean jj_3R_12() {
        return this.jj_3R_26();
    }

    private final boolean jj_3_6() {
        return this.jj_3R_13();
    }

    private final boolean jj_3_19() {
        return this.jj_3R_13();
    }

    private final boolean jj_3_18() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = token;
            if (this.jj_3R_18()) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(69)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_17() {
        return this.jj_3R_13();
    }

    private final boolean jj_3_28() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(30)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private final boolean jj_3_21() {
        if (this.jj_3R_19()) {
            return true;
        }
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_23() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(39)) {
            return true;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        return this.jj_3R_15();
    }

    private final boolean jj_3_20() {
        if (this.jj_3R_19()) {
            return true;
        }
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3_27() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3_4() {
        return this.jj_3R_13();
    }

    private final boolean jj_3_3() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_11()) {
            this.jj_scanpos = token;
            if (this.jj_3R_12()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_11() {
        return this.jj_3R_13();
    }

    private final boolean jj_3R_38() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(10)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(11)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(12)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(13)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(14)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(15)) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(16)) {
                                        this.jj_scanpos = token;
                                        if (this.jj_scan_token(17)) {
                                            this.jj_scanpos = token;
                                            if (this.jj_scan_token(18)) {
                                                this.jj_scanpos = token;
                                                if (this.jj_scan_token(19)) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_scan_token(24)) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_scan_token(25)) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_scan_token(26)) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_scan_token(27)) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_scan_token(28)) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_scan_token(29)) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_scan_token(30)) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_scan_token(31)) {
                                                                                    this.jj_scanpos = token;
                                                                                    if (this.jj_scan_token(32)) {
                                                                                        this.jj_scanpos = token;
                                                                                        if (this.jj_scan_token(43)) {
                                                                                            this.jj_scanpos = token;
                                                                                            if (this.jj_scan_token(44)) {
                                                                                                this.jj_scanpos = token;
                                                                                                if (this.jj_scan_token(33)) {
                                                                                                    this.jj_scanpos = token;
                                                                                                    if (this.jj_scan_token(34)) {
                                                                                                        this.jj_scanpos = token;
                                                                                                        if (this.jj_scan_token(35)) {
                                                                                                            this.jj_scanpos = token;
                                                                                                            if (this.jj_scan_token(36)) {
                                                                                                                this.jj_scanpos = token;
                                                                                                                if (this.jj_scan_token(37)) {
                                                                                                                    this.jj_scanpos = token;
                                                                                                                    if (this.jj_scan_token(38)) {
                                                                                                                        this.jj_scanpos = token;
                                                                                                                        if (this.jj_scan_token(39)) {
                                                                                                                            this.jj_scanpos = token;
                                                                                                                            if (this.jj_scan_token(40)) {
                                                                                                                                this.jj_scanpos = token;
                                                                                                                                if (this.jj_scan_token(41)) {
                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                    if (this.jj_scan_token(42)) {
                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                        if (this.jj_scan_token(45)) {
                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                            if (this.jj_scan_token(46)) {
                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                if (this.jj_scan_token(47)) {
                                                                                                                                                    return true;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_42() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(10)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(11)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(12)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(13)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(14)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(15)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_22() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(39)) {
            return true;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        return this.jj_3R_33();
    }

    private final boolean jj_3_32() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_21() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        return this.jj_3R_15();
    }

    private final boolean jj_3_34() {
        return this.jj_3R_23();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{96, 0, 0, -15729152, 0, 0, 0, -15729152, 0, 65024, 96, 0, 96, 0, 96, 369360896, 96, 96, -15729152};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, -1609302016, 1076363264, 65535, 0x1B000000, 0x3000000, 0x1B000000, 65535, 0, 0, 0, 0, 0, 0, 0, 165, 0, 0, 402718719};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 1, 0, 0, 0, 0, 0, 2048, 0, 0, 2048, 0, 2048, 0, 0, 0, 32, 0};
    }

    public TemplateParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public TemplateParser(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new TemplateParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 19; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 19; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public TemplateParser(Reader reader) {
        int n;
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new TemplateParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 19; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 19; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public TemplateParser(TemplateParserTokenManager templateParserTokenManager) {
        int n;
        this.token_source = templateParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 19; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(TemplateParserTokenManager templateParserTokenManager) {
        int n;
        this.token_source = templateParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 19; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[83];
        for (n2 = 0; n2 < 83; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 19; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) == 0) continue;
                blArray[64 + n] = true;
            }
        }
        for (n2 = 0; n2 < 83; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 36; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        TemplateParser.jj_la1_0();
        TemplateParser.jj_la1_1();
        TemplateParser.jj_la1_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class SourceItemInfo<T> {
        final T parsedContent;
        final int lineNum;

        SourceItemInfo(T t, int n) {
            this.parsedContent = t;
            this.lineNum = n;
        }
    }
}

