/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.AbstractNode;
import com.google.template.soy.soytree.SoyNode;

public abstract class AbstractSoyNode
extends AbstractNode
implements SoyNode {
    private int id;
    private SourceLocation location = SourceLocation.UNKNOWN;
    private SoyNode.SyntaxVersion syntaxVersion;

    protected AbstractSoyNode(int n) {
        Preconditions.checkNotNull((Object)n);
        this.id = n;
        this.syntaxVersion = SoyNode.SyntaxVersion.V2;
    }

    protected AbstractSoyNode(AbstractSoyNode abstractSoyNode) {
        super(abstractSoyNode);
        this.id = abstractSoyNode.id;
        this.location = abstractSoyNode.location;
        this.syntaxVersion = abstractSoyNode.syntaxVersion;
    }

    @Override
    public void setId(int n) {
        this.id = n;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public SourceLocation getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(SourceLocation sourceLocation) {
        if (sourceLocation == null) {
            throw new NullPointerException();
        }
        this.location = sourceLocation;
    }

    @Override
    public SoyNode.SyntaxVersion getSyntaxVersion() {
        return this.syntaxVersion;
    }

    protected void maybeSetSyntaxVersion(SoyNode.SyntaxVersion syntaxVersion) {
        if (this.syntaxVersion.compareTo(syntaxVersion) > 0) {
            this.syntaxVersion = syntaxVersion;
        }
    }

    @Override
    public SoyNode.ParentSoyNode<?> getParent() {
        return (SoyNode.ParentSoyNode)super.getParent();
    }

    @Override
    public abstract SoyNode clone();

    @Override
    public String toString() {
        return super.toString() + "_" + this.id;
    }
}

