/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public class CallParamValueNode
extends CallParamNode
implements SoyNode.ExprHolderNode {
    private final String key;
    private final ExprUnion valueExprUnion;

    public CallParamValueNode(int n, String string) throws SoySyntaxException {
        super(n, string);
        CallParamNode.CommandTextParseResult commandTextParseResult = this.parseCommandTextHelper(string);
        this.key = commandTextParseResult.key;
        this.valueExprUnion = commandTextParseResult.valueExprUnion;
        if (this.valueExprUnion == null) {
            throw new SoySyntaxException("A 'param' tag should be self-ending (with a trailing '/') if and only if it also contains a value (invalid tag is {param " + string + " /}).");
        }
        if (this.valueExprUnion.getExpr() == null) {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
        }
    }

    protected CallParamValueNode(CallParamValueNode callParamValueNode) {
        super(callParamValueNode);
        this.key = callParamValueNode.key;
        this.valueExprUnion = callParamValueNode.valueExprUnion != null ? callParamValueNode.valueExprUnion.clone() : null;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_PARAM_VALUE_NODE;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getValueExprText() {
        return this.valueExprUnion.getExprText();
    }

    public ExprUnion getValueExprUnion() {
        return this.valueExprUnion;
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(true);
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)this.valueExprUnion);
    }

    @Override
    public CallParamValueNode clone() {
        return new CallParamValueNode(this);
    }
}

