/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ForNode
extends AbstractBlockCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode,
SoyNode.ConditionalBlockNode,
SoyNode.LoopNode,
SoyNode.ExprHolderNode,
SoyNode.LocalVarBlockNode {
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("( [$] \\w+ ) \\s+ in \\s+ range[(] \\s* (.*) \\s* [)]", 36);
    private final String varName;
    private final ImmutableList<String> rangeArgTexts;
    private final ImmutableList<ExprRootNode<?>> rangeArgs;

    public ForNode(int n, String string) throws SoySyntaxException {
        super(n, "for", string);
        List<ExprRootNode<?>> list;
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new SoySyntaxException("Invalid 'for' command text \"" + string + "\".");
        }
        try {
            this.varName = ((VarNode)new ExpressionParser(matcher.group(1)).parseVariable().getChild(0)).getName();
        }
        catch (TokenMgrError tokenMgrError) {
            throw this.createExceptionForInvalidCommandText("variable name", tokenMgrError);
        }
        catch (ParseException parseException) {
            throw this.createExceptionForInvalidCommandText("variable name", parseException);
        }
        try {
            list = new ExpressionParser(matcher.group(2)).parseExpressionList();
        }
        catch (TokenMgrError tokenMgrError) {
            throw this.createExceptionForInvalidCommandText("range specification", tokenMgrError);
        }
        catch (ParseException parseException) {
            throw this.createExceptionForInvalidCommandText("range specification", parseException);
        }
        if (list.size() > 3) {
            throw new SoySyntaxException("Invalid range specification in 'for' command text \"" + string + "\".");
        }
        this.rangeArgs = ImmutableList.copyOf(list);
        ArrayList arrayList = Lists.newArrayList();
        for (ExprRootNode exprRootNode : this.rangeArgs) {
            arrayList.add(exprRootNode.toSourceString());
        }
        this.rangeArgTexts = ImmutableList.copyOf((Collection)arrayList);
    }

    protected ForNode(ForNode forNode) {
        super(forNode);
        this.varName = forNode.varName;
        this.rangeArgTexts = forNode.rangeArgTexts;
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)forNode.rangeArgs.size());
        for (ExprRootNode exprRootNode : forNode.rangeArgs) {
            arrayList.add(exprRootNode.clone());
        }
        this.rangeArgs = ImmutableList.copyOf((Collection)arrayList);
    }

    private SoySyntaxException createExceptionForInvalidCommandText(String string, Throwable throwable) {
        return new SoySyntaxException("Invalid " + string + " in 'for' command text \"" + this.getCommandText() + "\".", throwable);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.FOR_NODE;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    public List<String> getRangeArgTexts() {
        return this.rangeArgTexts;
    }

    public List<ExprRootNode<?>> getRangeArgs() {
        return this.rangeArgs;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ExprUnion.createList(this.rangeArgs);
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public ForNode clone() {
        return new ForNode(this);
    }
}

