/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public class IfCondNode
extends AbstractBlockCommandNode
implements SoyNode.ConditionalBlockNode,
SoyNode.ExprHolderNode {
    private final ExprUnion exprUnion;

    public IfCondNode(int n, String string, String string2) {
        super(n, string, string2);
        ExprRootNode<?> exprRootNode;
        Preconditions.checkArgument((string.equals("if") || string.equals("elseif") ? 1 : 0) != 0);
        try {
            exprRootNode = new ExpressionParser(string2).parseExpression();
        }
        catch (TokenMgrError tokenMgrError) {
            exprRootNode = null;
        }
        catch (ParseException parseException) {
            exprRootNode = null;
        }
        if (exprRootNode != null) {
            this.exprUnion = new ExprUnion(exprRootNode);
        } else {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
            this.exprUnion = new ExprUnion(string2);
        }
    }

    protected IfCondNode(IfCondNode ifCondNode) {
        super(ifCondNode);
        this.exprUnion = ifCondNode.exprUnion != null ? ifCondNode.exprUnion.clone() : null;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.IF_COND_NODE;
    }

    public String getExprText() {
        return this.exprUnion.getExprText();
    }

    public ExprUnion getExprUnion() {
        return this.exprUnion;
    }

    @Override
    public String getCommandName() {
        return this.getParent().getChild(0) == this ? "if" : "elseif";
    }

    @Override
    public String getCommandText() {
        return this.exprUnion.getExprText();
    }

    @Override
    public String toSourceString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTagString());
        this.appendSourceStringForChildren(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)this.exprUnion);
    }

    @Override
    public IfCondNode clone() {
        return new IfCondNode(this);
    }
}

