/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarNode;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class LetNode
extends AbstractCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode,
SoyNode.LocalVarInlineNode {
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("( [$] \\w+ ) (?: \\s* : \\s* (\\S .*) )?", 36);
    private final boolean isVarNameUnique;

    protected LetNode(int n, boolean bl, String string) {
        super(n, "let", string);
        this.isVarNameUnique = bl;
    }

    protected LetNode(LetNode letNode) {
        super(letNode);
        this.isVarNameUnique = letNode.isVarNameUnique;
    }

    protected Pair<String, ExprRootNode<?>> parseCommandTextHelper(String string) throws SoySyntaxException {
        ExprRootNode<?> exprRootNode;
        String string2;
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new SoySyntaxException("Invalid 'let' command text \"" + string + "\".");
        }
        try {
            string2 = ((VarNode)new ExpressionParser(matcher.group(1)).parseVariable().getChild(0)).getName();
        }
        catch (TokenMgrError tokenMgrError) {
            throw this.createExceptionForInvalidCommandText("variable name", tokenMgrError);
        }
        catch (ParseException parseException) {
            throw this.createExceptionForInvalidCommandText("variable name", parseException);
        }
        if (matcher.group(2) != null) {
            try {
                exprRootNode = new ExpressionParser(matcher.group(2)).parseExpression();
            }
            catch (TokenMgrError tokenMgrError) {
                throw this.createExceptionForInvalidCommandText("value expression", tokenMgrError);
            }
            catch (ParseException parseException) {
                throw this.createExceptionForInvalidCommandText("value expression", parseException);
            }
        } else {
            exprRootNode = null;
        }
        return Pair.of(string2, exprRootNode);
    }

    private SoySyntaxException createExceptionForInvalidCommandText(String string, Throwable throwable) {
        return new SoySyntaxException("Invalid " + string + " in 'let' command text \"" + this.getCommandText() + "\".", throwable);
    }

    public String getUniqueVarName() {
        return this.isVarNameUnique ? this.getVarName() : this.getVarName() + "__soy" + this.getId();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }
}

