/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.SoyNode;

public class MsgPluralCaseNode
extends CaseOrDefaultNode
implements SoyNode.MsgBlockNode {
    private final int caseNumber;

    public MsgPluralCaseNode(int n, String string) throws SoySyntaxException {
        super(n, "case", string);
        try {
            this.caseNumber = Integer.parseInt(string);
            if (this.caseNumber < 0) {
                throw new SoySyntaxException("Plural cases must be nonnegative integers.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SoySyntaxException("Invalid number in 'plural case' command text \"" + this.getCommandText() + "\".", numberFormatException);
        }
    }

    protected MsgPluralCaseNode(MsgPluralCaseNode msgPluralCaseNode) {
        super(msgPluralCaseNode);
        this.caseNumber = msgPluralCaseNode.caseNumber;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_PLURAL_CASE_NODE;
    }

    public int getCaseNumber() {
        return this.caseNumber;
    }

    @Override
    public MsgPluralCaseNode clone() {
        return new MsgPluralCaseNode(this);
    }
}

