/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PrintDirectiveNode
extends AbstractSoyNode
implements SoyNode.ExprHolderNode {
    private static final Set<String> V1_DIRECTIVE_NAMES = ImmutableSet.of((Object)"|noescape", (Object)"|escape", (Object)"|insertwordbreaks");
    private static final Map<String, String> DEPRECATED_DIRECTIVE_NAMES = ImmutableMap.of((Object)"|noescape", (Object)"|noAutoescape", (Object)"|escape", (Object)"|escapeHtml", (Object)"|escapeJs", (Object)"|escapeJsString", (Object)"|insertwordbreaks", (Object)"|insertWordBreaks");
    private String name;
    private final String argsText;
    private final ImmutableList<ExprRootNode<?>> args;

    public PrintDirectiveNode(int n, String string, String string2) throws SoySyntaxException {
        super(n);
        List<Object> list;
        String string3 = DEPRECATED_DIRECTIVE_NAMES.get(string);
        if (string3 == null) {
            this.name = string;
        } else {
            this.name = string3;
            if (V1_DIRECTIVE_NAMES.contains(string)) {
                this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
            }
        }
        this.argsText = string2;
        if (this.argsText.length() > 0) {
            try {
                list = new ExpressionParser(string2).parseExpressionList();
            }
            catch (TokenMgrError tokenMgrError) {
                throw this.createExceptionForInvalidArgs(tokenMgrError);
            }
            catch (ParseException parseException) {
                throw this.createExceptionForInvalidArgs(parseException);
            }
        } else {
            list = Collections.emptyList();
        }
        this.args = ImmutableList.copyOf(list);
    }

    protected PrintDirectiveNode(PrintDirectiveNode printDirectiveNode) {
        super(printDirectiveNode);
        this.name = printDirectiveNode.name;
        this.argsText = printDirectiveNode.argsText;
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)printDirectiveNode.args.size());
        for (ExprRootNode exprRootNode : printDirectiveNode.args) {
            arrayList.add(exprRootNode.clone());
        }
        this.args = ImmutableList.copyOf((Collection)arrayList);
    }

    private SoySyntaxException createExceptionForInvalidArgs(Throwable throwable) {
        return new SoySyntaxException("Invalid arguments for print directive \"" + this.toString() + "\".", throwable);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.PRINT_DIRECTIVE_NODE;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getArgsText() {
        return this.argsText;
    }

    public List<ExprRootNode<?>> getArgs() {
        return this.args;
    }

    @Override
    public String toSourceString() {
        return this.name + (this.argsText.length() > 0 ? ":" + this.argsText : "");
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ExprUnion.createList(this.args);
    }

    @Override
    public PrintDirectiveNode clone() {
        return new PrintDirectiveNode(this);
    }
}

