/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import javax.annotation.Nullable;

public class SoytreeUtils {
    public static SoySyntaxException createSoySyntaxExceptionWithMetaInfo(@Nullable String string, @Nullable Throwable throwable, SoyNode soyNode) {
        SoySyntaxException soySyntaxException;
        if (string != null && throwable != null) {
            soySyntaxException = new SoySyntaxException(string, throwable);
        } else if (string != null) {
            soySyntaxException = new SoySyntaxException(string);
        } else if (throwable != null) {
            soySyntaxException = new SoySyntaxException(throwable);
        } else {
            throw new AssertionError();
        }
        SoytreeUtils.associateMetaInfoWithException(soyNode, soySyntaxException);
        return soySyntaxException;
    }

    private static void associateMetaInfoWithException(SoyNode soyNode, SoySyntaxException soySyntaxException) {
        TemplateNode templateNode = soyNode.getNearestAncestor(TemplateNode.class);
        if (soySyntaxException.getSourceLocation() == SourceLocation.UNKNOWN) {
            soySyntaxException.setSourceLocation(soyNode.getLocation());
        }
        if (soySyntaxException.getTemplateName() == null && templateNode != null) {
            soySyntaxException.setTemplateName(templateNode.getTemplateNameForUserMsgs());
        }
    }

    public static <R> void execOnAllV2Exprs(SoyNode soyNode, AbstractExprNodeVisitor<R> abstractExprNodeVisitor) {
        SoytreeUtils.execOnAllV2ExprsShortcircuitably(soyNode, abstractExprNodeVisitor, null);
    }

    public static <R> void execOnAllV2ExprsShortcircuitably(SoyNode soyNode, AbstractExprNodeVisitor<R> abstractExprNodeVisitor, Shortcircuiter<R> shortcircuiter) {
        new VisitAllV2ExprsVisitor<R>(abstractExprNodeVisitor, shortcircuiter).exec(soyNode);
    }

    public static <T extends SoyNode> T cloneWithNewIds(T t) {
        SoyNode soyNode = t.clone();
        IdGenerator idGenerator = t.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator();
        new GenNewIdsVisitor(idGenerator).exec(soyNode);
        return (T)soyNode;
    }

    private static class GenNewIdsVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private IdGenerator nodeIdGen;

        public GenNewIdsVisitor(IdGenerator idGenerator) {
            this.nodeIdGen = idGenerator;
        }

        @Override
        protected void visitSoyNode(SoyNode soyNode) {
            soyNode.setId(this.nodeIdGen.genId());
            if (soyNode instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)soyNode);
            }
        }
    }

    private static class VisitAllV2ExprsVisitor<R>
    extends AbstractSoyNodeVisitor<R> {
        private final AbstractExprNodeVisitor<R> exprNodeVisitor;
        private final Shortcircuiter<R> shortcircuiter;

        public VisitAllV2ExprsVisitor(AbstractExprNodeVisitor<R> abstractExprNodeVisitor, @Nullable Shortcircuiter<R> shortcircuiter) {
            this.exprNodeVisitor = abstractExprNodeVisitor;
            this.shortcircuiter = shortcircuiter;
        }

        @Override
        protected void visitSoyNode(SoyNode soyNode) {
            if (soyNode instanceof SoyNode.ParentSoyNode) {
                for (Object object : ((SoyNode.ParentSoyNode)soyNode).getChildren()) {
                    this.visit((SoyNode)object);
                    if (this.shortcircuiter == null || !this.shortcircuiter.shouldShortcircuit(this.exprNodeVisitor)) continue;
                    return;
                }
            }
            if (soyNode instanceof SoyNode.ExprHolderNode) {
                SoyNode.ExprHolderNode exprHolderNode = (SoyNode.ExprHolderNode)soyNode;
                for (ExprUnion exprUnion : exprHolderNode.getAllExprUnions()) {
                    if (exprUnion.getExpr() == null) continue;
                    try {
                        this.exprNodeVisitor.exec(exprUnion.getExpr());
                    }
                    catch (SoySyntaxException soySyntaxException) {
                        SoytreeUtils.associateMetaInfoWithException(exprHolderNode, soySyntaxException);
                        throw soySyntaxException;
                    }
                }
            }
        }
    }

    public static interface Shortcircuiter<R> {
        public boolean shouldShortcircuit(AbstractExprNodeVisitor<R> var1);
    }
}

