/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.Lists;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public class SwitchCaseNode
extends CaseOrDefaultNode
implements SoyNode.ConditionalBlockNode,
SoyNode.ExprHolderNode {
    private final String exprListText;
    private final List<ExprRootNode<?>> exprList;

    public SwitchCaseNode(int n, String string) throws SoySyntaxException {
        super(n, "case", string);
        this.exprListText = string;
        try {
            this.exprList = new ExpressionParser(this.exprListText).parseExpressionList();
        }
        catch (TokenMgrError tokenMgrError) {
            throw this.createExceptionForInvalidExprList(tokenMgrError);
        }
        catch (ParseException parseException) {
            throw this.createExceptionForInvalidExprList(parseException);
        }
    }

    protected SwitchCaseNode(SwitchCaseNode switchCaseNode) {
        super(switchCaseNode);
        this.exprListText = switchCaseNode.exprListText;
        this.exprList = Lists.newArrayListWithCapacity((int)switchCaseNode.exprList.size());
        for (ExprRootNode<?> exprRootNode : switchCaseNode.exprList) {
            this.exprList.add((ExprRootNode<?>)exprRootNode.clone());
        }
    }

    private SoySyntaxException createExceptionForInvalidExprList(Throwable throwable) {
        return new SoySyntaxException("Invalid expression list in 'case' command text \"" + this.getCommandText() + "\".", throwable);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SWITCH_CASE_NODE;
    }

    public String getExprListText() {
        return this.exprListText;
    }

    public List<ExprRootNode<?>> getExprList() {
        return this.exprList;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ExprUnion.createList(this.exprList);
    }

    @Override
    public SwitchCaseNode clone() {
        return new SwitchCaseNode(this);
    }
}

