/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class TemplateBasicNode
extends TemplateNode {
    private static final Pattern NONATTRIBUTE_TEMPLATE_NAME = Pattern.compile("^ (?! name=\") [.\\w]+ (?= \\s | $)", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("template", new CommandTextAttributesParser.Attribute("name", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, "__NDVBR__"), new CommandTextAttributesParser.Attribute("private", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, "false"), new CommandTextAttributesParser.Attribute("override", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES_AND_NULL, null), new CommandTextAttributesParser.Attribute("autoescape", AutoescapeMode.getAttributeValuesAndNull(), null));
    private final boolean isOverride;

    public TemplateBasicNode(int n, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String string, @Nullable String string2) throws SoySyntaxException {
        this(n, soyFileHeaderInfo, TemplateBasicNode.parseCommandTextHelper(soyFileHeaderInfo, string), string2);
    }

    private static final CommandTextInfo parseCommandTextHelper(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String string) {
        boolean bl;
        String string2;
        String string3;
        Map<String, String> map;
        String string4;
        SoyNode.SyntaxVersion syntaxVersion = SoyNode.SyntaxVersion.V2;
        String string5 = string;
        Matcher matcher = NONATTRIBUTE_TEMPLATE_NAME.matcher(string5);
        if (matcher.find()) {
            string5 = matcher.replaceFirst("name=\"" + matcher.group() + "\"");
        }
        if (BaseUtils.isIdentifierWithLeadingDot(string4 = (map = ATTRIBUTES_PARSER.parse(string5)).get("name"))) {
            string3 = string4;
            string2 = soyFileHeaderInfo.namespace + string3;
        } else if (BaseUtils.isDottedIdentifier(string4)) {
            syntaxVersion = SoyNode.SyntaxVersion.V1;
            string2 = string4;
            string3 = null;
        } else {
            throw new SoySyntaxException("Invalid template name \"" + string4 + "\".");
        }
        boolean bl2 = map.get("private").equals("true");
        String string6 = map.get("override");
        if (string6 == null) {
            bl = false;
        } else {
            syntaxVersion = SoyNode.SyntaxVersion.V1;
            bl = string6.equals("true");
        }
        String string7 = map.get("autoescape");
        AutoescapeMode autoescapeMode = string7 != null ? AutoescapeMode.forAttributeValue(string7) : soyFileHeaderInfo.defaultAutoescapeMode;
        return new CommandTextInfo(string, string2, string3, bl, bl2, autoescapeMode, syntaxVersion);
    }

    public TemplateBasicNode(int n, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String string, @Nullable String string2, boolean bl, boolean bl2, boolean bl3, AutoescapeMode autoescapeMode, @Nullable String string3, SoyNode.SyntaxVersion syntaxVersion) {
        this(n, soyFileHeaderInfo, TemplateBasicNode.buildCommandTextInfoHelper(string, string2, bl, bl2, bl3, autoescapeMode, syntaxVersion), string3);
    }

    private static final CommandTextInfo buildCommandTextInfoHelper(String string, @Nullable String string2, boolean bl, boolean bl2, boolean bl3, AutoescapeMode autoescapeMode, SoyNode.SyntaxVersion syntaxVersion) {
        String string3;
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(string));
        Preconditions.checkArgument((string2 == null || BaseUtils.isIdentifierWithLeadingDot(string2) ? 1 : 0) != 0);
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = string3 = string2 != null ? string2 : string;
        if (bl) {
            stringBuilder.append("name=\"").append(string3).append('\"');
        } else {
            stringBuilder.append(string3);
        }
        stringBuilder.append(" autoescape=\"").append(autoescapeMode.getAttributeValue()).append('\"');
        if (bl2) {
            stringBuilder.append(" override=\"true\"");
        }
        if (bl3) {
            stringBuilder.append(" private=\"true\"");
        }
        return new CommandTextInfo(stringBuilder.toString(), string, string2, bl2, bl3, autoescapeMode, syntaxVersion);
    }

    private TemplateBasicNode(int n, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, CommandTextInfo commandTextInfo, @Nullable String string) {
        super(n, soyFileHeaderInfo, "template", commandTextInfo, string);
        this.isOverride = commandTextInfo.isOverride;
    }

    protected TemplateBasicNode(TemplateBasicNode templateBasicNode) {
        super(templateBasicNode);
        this.isOverride = templateBasicNode.isOverride;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_BASIC_NODE;
    }

    @Override
    public String getTemplateNameForUserMsgs() {
        return this.getTemplateName();
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    @Override
    public TemplateBasicNode clone() {
        return new TemplateBasicNode(this);
    }

    @Immutable
    private static class CommandTextInfo
    extends TemplateNode.CommandTextInfo {
        public final boolean isOverride;

        public CommandTextInfo(String string, String string2, @Nullable String string3, boolean bl, boolean bl2, AutoescapeMode autoescapeMode, SoyNode.SyntaxVersion syntaxVersion) {
            super(string, string2, string3, bl2, autoescapeMode, syntaxVersion);
            this.isOverride = bl;
        }
    }
}

