/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class TemplateDelegateNode
extends TemplateNode {
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("([.\\w]+) ( \\s .* | $ )", 36);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("deltemplate", new CommandTextAttributesParser.Attribute("autoescape", AutoescapeMode.getAttributeValuesAndNull(), null));
    private final String delTemplateName;
    private final int delPriority;

    public TemplateDelegateNode(int n, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String string, @Nullable String string2) throws SoySyntaxException {
        this(n, soyFileHeaderInfo, TemplateDelegateNode.parseCommandTextHelper(n, soyFileHeaderInfo, string), string2);
    }

    public TemplateDelegateNode(int n, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String string, int n2, AutoescapeMode autoescapeMode, @Nullable String string2) {
        this(n, soyFileHeaderInfo, TemplateDelegateNode.buildCommandTextInfoHelper(n, soyFileHeaderInfo, null, string, n2, autoescapeMode), string2);
    }

    private static final CommandTextInfo parseCommandTextHelper(int n, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String string) {
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new SoySyntaxException("Invalid 'deltemplate' command text \"" + string + "\".");
        }
        String string2 = matcher.group(1);
        if (!BaseUtils.isDottedIdentifier(string2)) {
            throw new SoySyntaxException("Invalid delegate template name \"" + string2 + "\".");
        }
        Map<String, String> map = ATTRIBUTES_PARSER.parse(matcher.group(2).trim());
        int n2 = soyFileHeaderInfo.defaultDelPriority;
        if (n2 < 0 || n2 > 1) {
            throw new SoySyntaxException(String.format("Invalid delegate template priority %s (valid range is 0 to %s).", n2, 1));
        }
        String string3 = map.get("autoescape");
        AutoescapeMode autoescapeMode = string3 != null ? AutoescapeMode.forAttributeValue(string3) : soyFileHeaderInfo.defaultAutoescapeMode;
        return TemplateDelegateNode.buildCommandTextInfoHelper(n, soyFileHeaderInfo, string, string2, n2, autoescapeMode);
    }

    private static CommandTextInfo buildCommandTextInfoHelper(int n, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, @Nullable String string, String string2, int n2, AutoescapeMode autoescapeMode) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(string2));
        Preconditions.checkArgument((0 <= n2 && n2 <= 1 ? 1 : 0) != 0);
        if (string == null) {
            string = string2 + " autoescape=\"" + autoescapeMode.getAttributeValue() + "\"";
        }
        String string3 = ".__soy_deltemplate" + n;
        String string4 = soyFileHeaderInfo.namespace + string3;
        return new CommandTextInfo(string, string2, n2, string4, string3, autoescapeMode);
    }

    private TemplateDelegateNode(int n, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, CommandTextInfo commandTextInfo, @Nullable String string) {
        super(n, soyFileHeaderInfo, "deltemplate", commandTextInfo, string);
        this.delTemplateName = commandTextInfo.delTemplateName;
        this.delPriority = commandTextInfo.delPriority;
    }

    protected TemplateDelegateNode(TemplateDelegateNode templateDelegateNode) {
        super(templateDelegateNode);
        this.delTemplateName = templateDelegateNode.delTemplateName;
        this.delPriority = templateDelegateNode.delPriority;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_DELEGATE_NODE;
    }

    @Override
    public String getTemplateNameForUserMsgs() {
        return this.delTemplateName;
    }

    public String getDelTemplateName() {
        return this.delTemplateName;
    }

    public int getDelPriority() {
        return this.delPriority;
    }

    @Override
    public TemplateDelegateNode clone() {
        return new TemplateDelegateNode(this);
    }

    @Immutable
    private static class CommandTextInfo
    extends TemplateNode.CommandTextInfo {
        public final String delTemplateName;
        public final int delPriority;

        public CommandTextInfo(String string, String string2, int n, String string3, @Nullable String string4, AutoescapeMode autoescapeMode) {
            super(string, string3, string4, false, autoescapeMode, SoyNode.SyntaxVersion.V2);
            this.delTemplateName = string2;
            this.delPriority = n;
        }
    }
}

