/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public abstract class TemplateNode
extends AbstractBlockCommandNode {
    public static final int MAX_PRIORITY = 1;
    private static final Pattern NEWLINE = Pattern.compile("\\n|\\r\\n?");
    private static final Pattern SOY_DOC_START = Pattern.compile("^ [/][*][*] [\\ ]* \\r?\\n?", 4);
    private static final Pattern SOY_DOC_END = Pattern.compile("\\r?\\n? [\\ ]* [*][/] $", 4);
    private static final Pattern SOY_DOC_DECL_PATTERN = Pattern.compile("( @param[?]? ) \\s+ ( \\S+ )", 4);
    private static final Pattern SOY_DOC_PARAM_TEXT_PATTERN = Pattern.compile("[a-zA-Z_]\\w*", 4);
    private final SoyFileHeaderInfo soyFileHeaderInfo;
    private final String templateName;
    @Nullable
    private final String partialTemplateName;
    private final boolean isPrivate;
    private final AutoescapeMode autoescapeMode;
    private String soyDoc;
    private String soyDocDesc;
    private ImmutableList<SoyDocParam> soyDocParams;

    protected TemplateNode(int n, SoyFileHeaderInfo soyFileHeaderInfo, String string, CommandTextInfo commandTextInfo, @Nullable String string2) {
        super(n, string, commandTextInfo.commandText);
        this.soyFileHeaderInfo = soyFileHeaderInfo;
        this.templateName = commandTextInfo.templateName;
        this.partialTemplateName = commandTextInfo.partialTemplateName;
        this.isPrivate = commandTextInfo.isPrivate;
        this.autoescapeMode = commandTextInfo.autoescapeMode;
        this.maybeSetSyntaxVersion(commandTextInfo.syntaxVersion);
        this.soyDoc = string2;
        if (string2 != null) {
            Preconditions.checkArgument((string2.startsWith("/**") && string2.endsWith("*/") ? 1 : 0) != 0);
            String string3 = TemplateNode.cleanSoyDocHelper(string2);
            this.soyDocDesc = TemplateNode.parseSoyDocDescHelper(string3);
            Pair<Boolean, List<SoyDocParam>> pair = TemplateNode.parseSoyDocDeclsHelper(string3);
            this.soyDocParams = ImmutableList.copyOf((Collection)((Collection)pair.second));
            if (((Boolean)pair.first).booleanValue()) {
                this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
            }
        } else {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
            this.soyDocDesc = null;
            this.soyDocParams = null;
        }
        if (this.partialTemplateName != null) {
            if (!BaseUtils.isIdentifierWithLeadingDot(this.partialTemplateName)) {
                throw new SoySyntaxException("Invalid template name \"" + this.partialTemplateName + "\".");
            }
        } else if (!BaseUtils.isDottedIdentifier(this.templateName)) {
            throw new SoySyntaxException("Invalid template name \"" + this.templateName + "\".");
        }
    }

    private static String cleanSoyDocHelper(String string) {
        string = NEWLINE.matcher(string).replaceAll("\n");
        string = SOY_DOC_START.matcher(string).replaceFirst("");
        string = SOY_DOC_END.matcher(string).replaceFirst("");
        ArrayList arrayList = Lists.newArrayList((Iterable)Splitter.on((Pattern)NEWLINE).split((CharSequence)string));
        TemplateNode.removeCommonStartCharHelper(arrayList, ' ', true);
        if (TemplateNode.removeCommonStartCharHelper(arrayList, '*', false) == 1) {
            TemplateNode.removeCommonStartCharHelper(arrayList, ' ', true);
        }
        return Joiner.on((char)'\n').join((Iterable)arrayList);
    }

    private static int removeCommonStartCharHelper(List<String> list, char c, boolean bl) {
        int n;
        int n2 = 0;
        boolean bl2 = true;
        do {
            n = 1;
            for (String string : list) {
                if (string.length() == 0) continue;
                n = 0;
                if (string.length() > n2 && string.charAt(n2) == c) continue;
                bl2 = false;
                break;
            }
            if (n != 0) {
                bl2 = false;
            }
            if (!bl2) continue;
            ++n2;
        } while (bl2 && bl);
        if (n2 > 0) {
            for (n = 0; n < list.size(); ++n) {
                String string = list.get(n);
                if (string.length() == 0) continue;
                list.set(n, string.substring(n2));
            }
        }
        return n2;
    }

    private static String parseSoyDocDescHelper(String string) {
        Matcher matcher = SOY_DOC_DECL_PATTERN.matcher(string);
        int n = matcher.find() ? matcher.start() : string.length();
        String string2 = string.substring(0, n);
        return CharMatcher.WHITESPACE.trimTrailingFrom((CharSequence)string2);
    }

    private static Pair<Boolean, List<SoyDocParam>> parseSoyDocDeclsHelper(String string) {
        boolean bl = false;
        ArrayList arrayList = Lists.newArrayList();
        HashSet hashSet = Sets.newHashSet();
        Matcher matcher = SOY_DOC_DECL_PATTERN.matcher(string);
        boolean bl2 = matcher.find();
        while (bl2) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            int n = matcher.end();
            bl2 = matcher.find();
            int n2 = bl2 ? matcher.start() : string.length();
            String string4 = string.substring(n, n2).trim();
            if (string2.equals("@param") || string2.equals("@param?")) {
                if (!SOY_DOC_PARAM_TEXT_PATTERN.matcher(string3).matches()) {
                    if (string3.startsWith("{")) {
                        bl = true;
                        continue;
                    }
                    throw new SoySyntaxException("Invalid SoyDoc declaration \"" + string2 + " " + string3 + "\".");
                }
                if (string3.equals("ij")) {
                    throw new SoySyntaxException("Invalid param name 'ij' ('ij' is for injected data ref).");
                }
                if (hashSet.contains(string3)) {
                    throw new SoySyntaxException("Duplicate declaration of param in SoyDoc: '" + string3 + "'.");
                }
                hashSet.add(string3);
                arrayList.add(new SoyDocParam(string3, string2.equals("@param"), string4));
                continue;
            }
            throw new AssertionError();
        }
        return Pair.of(bl, arrayList);
    }

    protected TemplateNode(TemplateNode templateNode) {
        super(templateNode);
        this.soyFileHeaderInfo = templateNode.soyFileHeaderInfo;
        this.templateName = templateNode.templateName;
        this.partialTemplateName = templateNode.partialTemplateName;
        this.isPrivate = templateNode.isPrivate;
        this.autoescapeMode = templateNode.autoescapeMode;
        this.soyDoc = templateNode.soyDoc;
        this.soyDocDesc = templateNode.soyDocDesc;
        this.soyDocParams = templateNode.soyDocParams;
    }

    public SoyFileHeaderInfo getSoyFileHeaderInfo() {
        return this.soyFileHeaderInfo;
    }

    public String getDelPackageName() {
        return this.soyFileHeaderInfo.delPackageName;
    }

    public abstract String getTemplateNameForUserMsgs();

    public String getTemplateName() {
        return this.templateName;
    }

    public String getPartialTemplateName() {
        return this.partialTemplateName;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public AutoescapeMode getAutoescapeMode() {
        return this.autoescapeMode;
    }

    public void clearSoyDocStrings() {
        this.soyDoc = null;
        this.soyDocDesc = null;
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)this.soyDocParams.size());
        for (SoyDocParam soyDocParam : this.soyDocParams) {
            arrayList.add(new SoyDocParam(soyDocParam.key, soyDocParam.isRequired, null));
        }
        this.soyDocParams = ImmutableList.copyOf((Collection)arrayList);
    }

    public String getSoyDoc() {
        return this.soyDoc;
    }

    public String getSoyDocDesc() {
        return this.soyDocDesc;
    }

    public List<SoyDocParam> getSoyDocParams() {
        return this.soyDocParams;
    }

    @Override
    public String toSourceString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.soyDoc != null) {
            stringBuilder.append(this.soyDoc).append("\n");
        }
        stringBuilder.append(this.getTagString()).append("\n");
        StringBuilder stringBuilder2 = new StringBuilder();
        this.appendSourceStringForChildren(stringBuilder2);
        int n = stringBuilder2.length();
        if (n != 0) {
            if (n != 1 && stringBuilder2.charAt(n - 1) == ' ') {
                stringBuilder2.replace(n - 1, n, "{sp}");
            }
            if (stringBuilder2.charAt(0) == ' ') {
                stringBuilder2.replace(0, 1, "{sp}");
            }
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("\n");
        stringBuilder.append("{/").append(this.getCommandName()).append("}\n");
        return stringBuilder.toString();
    }

    @Immutable
    public static final class SoyDocParam
    extends SoyDocDecl {
        public final String key;
        public final boolean isRequired;

        public SoyDocParam(String string, boolean bl, @Nullable String string2) {
            super(string2);
            Preconditions.checkArgument((string != null ? 1 : 0) != 0);
            this.key = string;
            this.isRequired = bl;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SoyDocParam)) {
                return false;
            }
            SoyDocParam soyDocParam = (SoyDocParam)object;
            return this.key.equals(soyDocParam.key) && this.isRequired == soyDocParam.isRequired;
        }

        public int hashCode() {
            return this.key.hashCode() + (this.isRequired ? 1 : 0);
        }
    }

    @Immutable
    private static abstract class SoyDocDecl {
        @Nullable
        public final String desc;

        private SoyDocDecl(@Nullable String string) {
            this.desc = string;
        }
    }

    @Immutable
    protected static class CommandTextInfo {
        public final String commandText;
        public final String templateName;
        @Nullable
        public final String partialTemplateName;
        public final boolean isPrivate;
        public final AutoescapeMode autoescapeMode;
        public final SoyNode.SyntaxVersion syntaxVersion;

        public CommandTextInfo(String string, String string2, @Nullable String string3, boolean bl, AutoescapeMode autoescapeMode, SoyNode.SyntaxVersion syntaxVersion) {
            Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(string2));
            Preconditions.checkArgument((string3 == null || BaseUtils.isIdentifierWithLeadingDot(string3) ? 1 : 0) != 0);
            this.commandText = string;
            this.templateName = string2;
            this.partialTemplateName = string3;
            this.isPrivate = bl;
            this.autoescapeMode = autoescapeMode;
            this.syntaxVersion = syntaxVersion;
        }
    }

    @Immutable
    public static class SoyFileHeaderInfo {
        @Nullable
        public final String delPackageName;
        public final int defaultDelPriority;
        public final String namespace;
        public final AutoescapeMode defaultAutoescapeMode;

        public SoyFileHeaderInfo(SoyFileNode soyFileNode) {
            this(soyFileNode.getDelPackageName(), soyFileNode.getNamespace(), soyFileNode.getDefaultAutoescapeMode());
        }

        public SoyFileHeaderInfo(String string) {
            this(null, string, AutoescapeMode.TRUE);
        }

        public SoyFileHeaderInfo(String string, String string2, AutoescapeMode autoescapeMode) {
            this.delPackageName = string;
            this.defaultDelPriority = string == null ? 0 : 1;
            this.namespace = string2;
            this.defaultAutoescapeMode = autoescapeMode;
        }
    }
}

