/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

public class TemplateRegistry {
    private final Map<String, TemplateBasicNode> basicTemplatesMap;
    private final Map<String, List<DelegateTemplateDivision>> delTemplatesMap;

    public TemplateRegistry(SoyFileSetNode soyFileSetNode) {
        Object object;
        TemplateDelegateNode templateDelegateNode;
        HashMap hashMap = Maps.newHashMap();
        HashMap hashMap2 = Maps.newHashMap();
        for (Object object2 : soyFileSetNode.getChildren()) {
            for (Object object3 : ((AbstractParentSoyNode)object2).getChildren()) {
                Map map;
                if (object3 instanceof TemplateBasicNode) {
                    hashMap.put(((TemplateNode)object3).getTemplateName(), (TemplateBasicNode)object3);
                    continue;
                }
                templateDelegateNode = (TemplateDelegateNode)object3;
                String string = templateDelegateNode.getDelTemplateName();
                int n = templateDelegateNode.getDelPriority();
                object = templateDelegateNode.getDelPackageName();
                Map map2 = (Map)hashMap2.get(string);
                if (map2 == null) {
                    map2 = Maps.newHashMap();
                    hashMap2.put(string, map2);
                }
                if ((map = (Map)map2.get(n)) == null) {
                    map = Maps.newHashMap();
                    map2.put(n, map);
                }
                if (map.containsKey(object)) {
                    TemplateDelegateNode templateDelegateNode2 = (TemplateDelegateNode)map.get(object);
                    String string2 = templateDelegateNode2.getNearestAncestor(SoyFileNode.class).getFilePath();
                    String string3 = templateDelegateNode.getNearestAncestor(SoyFileNode.class).getFilePath();
                    if (string3.equals(string2)) {
                        throw new SoySyntaxException(String.format("Found two definitions for delegate template name '%s' in the same delegatepackage, both in the file %s.", string, string3));
                    }
                    throw new SoySyntaxException(String.format("Found two definitions for delegate template name '%s' in the same delegatepackage, in two different files %s and %s.", string, string2, string3));
                }
                map.put(object, templateDelegateNode);
            }
        }
        this.basicTemplatesMap = Collections.unmodifiableMap(hashMap);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Object object4 : hashMap2.keySet()) {
            Object object3;
            object3 = (Map)hashMap2.get(object4);
            templateDelegateNode = ImmutableList.builder();
            for (int i = 1; i >= 0; --i) {
                if (!object3.containsKey(i)) continue;
                Map map = (Map)object3.get(i);
                object = new DelegateTemplateDivision(i, map);
                templateDelegateNode.add(object);
            }
            builder.put(object4, (Object)templateDelegateNode.build());
        }
        this.delTemplatesMap = builder.build();
    }

    public Map<String, TemplateBasicNode> getBasicTemplatesMap() {
        return this.basicTemplatesMap;
    }

    public TemplateBasicNode getBasicTemplate(String string) {
        return this.basicTemplatesMap.get(string);
    }

    public Map<String, List<DelegateTemplateDivision>> getDelegateTemplatesMap() {
        return this.delTemplatesMap;
    }

    public List<DelegateTemplateDivision> getSortedDelegateTemplateDivisions(String string) {
        return this.delTemplatesMap.get(string);
    }

    public TemplateDelegateNode selectDelegateTemplate(String string, Set<String> set) throws DelegateTemplateConflictException {
        for (DelegateTemplateDivision delegateTemplateDivision : this.delTemplatesMap.get(string)) {
            TemplateDelegateNode templateDelegateNode = null;
            for (String string2 : delegateTemplateDivision.delPackageNameToDelTemplateMap.keySet()) {
                if (string2 != null && !set.contains(string2)) continue;
                if (templateDelegateNode != null) {
                    throw new DelegateTemplateConflictException(String.format("For delegate template name '%s', found two active implementations with equal priority in delegate packages '%s' and '%s'.", string, templateDelegateNode.getDelPackageName(), string2));
                }
                templateDelegateNode = delegateTemplateDivision.delPackageNameToDelTemplateMap.get(string2);
            }
            if (templateDelegateNode == null) continue;
            return templateDelegateNode;
        }
        return null;
    }

    public static class DelegateTemplateConflictException
    extends Exception {
        public DelegateTemplateConflictException(String string) {
            super(string);
        }
    }

    @Immutable
    public static class DelegateTemplateDivision {
        public final int delPriority;
        public final Map<String, TemplateDelegateNode> delPackageNameToDelTemplateMap;

        public DelegateTemplateDivision(int n, Map<String, TemplateDelegateNode> map) {
            this.delPriority = n;
            this.delPackageNameToDelTemplateMap = Collections.unmodifiableMap(Maps.newHashMap(map));
        }
    }
}

