/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.InsertMsgsVisitor;
import com.google.template.soy.parseinfo.SoyTemplateInfo;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.MarkLocalVarDataRefsVisitor;
import com.google.template.soy.sharedpasses.RenameCssVisitor;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.RenderVisitor;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.SoyTofuException;
import com.google.template.soy.tofu.internal.MarkParentNodesNeedingEnvFramesVisitor;
import com.google.template.soy.tofu.internal.NamespacedTofu;
import com.google.template.soy.tofu.internal.TofuRenderVisitorFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class BaseTofu
implements SoyTofu {
    private final GuiceSimpleScope apiCallScope;
    private final TofuRenderVisitorFactory tofuRenderVisitorFactory;
    private final SimplifyVisitor simplifyVisitor;
    private final SoyFileSetNode soyTree;
    private final boolean isCaching;
    private final Map<Pair<SoyMsgBundle, SoyCssRenamingMap>, TemplateRegistry> cachedTemplateRegistries;
    private final TemplateRegistry templateRegistryForNoCaching;

    @AssistedInject
    public BaseTofu(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope guiceSimpleScope, TofuRenderVisitorFactory tofuRenderVisitorFactory, SimplifyVisitor simplifyVisitor, @Assisted SoyFileSetNode soyFileSetNode, @Assisted boolean bl) {
        this.apiCallScope = guiceSimpleScope;
        this.tofuRenderVisitorFactory = tofuRenderVisitorFactory;
        this.simplifyVisitor = simplifyVisitor;
        this.soyTree = soyFileSetNode;
        this.isCaching = bl;
        if (bl) {
            this.cachedTemplateRegistries = Maps.newHashMap();
            this.addToCache(null, null);
        } else {
            this.cachedTemplateRegistries = null;
        }
        this.templateRegistryForNoCaching = this.buildTemplateRegistry(soyFileSetNode.clone());
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public SoyTofu forNamespace(@Nullable String string) {
        return string == null ? this : new NamespacedTofu(this, string);
    }

    @Override
    public boolean isCaching() {
        return this.isCaching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToCache(@Nullable SoyMsgBundle soyMsgBundle, @Nullable SoyCssRenamingMap soyCssRenamingMap) {
        if (!this.isCaching) {
            throw new SoyTofuException("Cannot addToCache() when isCaching is false.");
        }
        this.apiCallScope.enter();
        try {
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, soyMsgBundle, 0);
            this.getCachedTemplateRegistry(Pair.of(soyMsgBundle, soyCssRenamingMap), true);
        }
        finally {
            this.apiCallScope.exit();
        }
    }

    @Override
    public SoyTofu.Renderer newRenderer(SoyTemplateInfo soyTemplateInfo) {
        return new RendererImpl(this, soyTemplateInfo.getName());
    }

    @Override
    public SoyTofu.Renderer newRenderer(String string) {
        return new RendererImpl(this, string);
    }

    private TemplateRegistry buildTemplateRegistry(SoyFileSetNode soyFileSetNode) {
        new MarkParentNodesNeedingEnvFramesVisitor().exec(soyFileSetNode);
        new MarkLocalVarDataRefsVisitor().exec(soyFileSetNode);
        return new TemplateRegistry(soyFileSetNode);
    }

    private TemplateRegistry getCachedTemplateRegistry(Pair<SoyMsgBundle, SoyCssRenamingMap> pair, boolean bl) {
        Preconditions.checkState((boolean)this.apiCallScope.isActive());
        TemplateRegistry templateRegistry = this.cachedTemplateRegistries.get(pair);
        if (templateRegistry == null) {
            if (!bl) {
                return null;
            }
            SoyFileSetNode soyFileSetNode = this.soyTree.clone();
            new InsertMsgsVisitor((SoyMsgBundle)pair.first, true).exec(soyFileSetNode);
            new RenameCssVisitor((SoyCssRenamingMap)pair.second).exec(soyFileSetNode);
            this.simplifyVisitor.exec(soyFileSetNode);
            templateRegistry = this.buildTemplateRegistry(soyFileSetNode);
            this.cachedTemplateRegistries.put(pair, templateRegistry);
        }
        return templateRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderMain(String string, @Nullable SoyMapData soyMapData, @Nullable SoyMapData soyMapData2, @Nullable Set<String> set, @Nullable SoyMsgBundle soyMsgBundle, @Nullable SoyCssRenamingMap soyCssRenamingMap, boolean bl) {
        if (set == null) {
            set = Collections.emptySet();
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.apiCallScope.enter();
        try {
            TemplateRegistry templateRegistry;
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, soyMsgBundle, 0);
            TemplateRegistry templateRegistry2 = templateRegistry = this.isCaching ? this.getCachedTemplateRegistry(Pair.of(soyMsgBundle, soyCssRenamingMap), bl) : null;
            if (templateRegistry != null) {
                this.renderMainHelper(templateRegistry, stringBuilder, string, soyMapData, soyMapData2, set, soyMsgBundle, null);
            } else {
                this.renderMainHelper(this.templateRegistryForNoCaching, stringBuilder, string, soyMapData, soyMapData2, set, soyMsgBundle, soyCssRenamingMap);
            }
        }
        finally {
            this.apiCallScope.exit();
        }
        return stringBuilder.toString();
    }

    private void renderMainHelper(TemplateRegistry templateRegistry, StringBuilder stringBuilder, String string, @Nullable SoyMapData soyMapData, @Nullable SoyMapData soyMapData2, Set<String> set, @Nullable SoyMsgBundle soyMsgBundle, @Nullable SoyCssRenamingMap soyCssRenamingMap) {
        TemplateBasicNode templateBasicNode = templateRegistry.getBasicTemplate(string);
        if (templateBasicNode == null) {
            throw new SoyTofuException("Attempting to render undefined template '" + string + "'.");
        }
        try {
            RenderVisitor renderVisitor = this.tofuRenderVisitorFactory.create(stringBuilder, templateRegistry, soyMapData, soyMapData2, null, set, soyMsgBundle, soyCssRenamingMap);
            renderVisitor.exec(templateBasicNode);
        }
        catch (RenderException renderException) {
            throw new SoyTofuException(renderException);
        }
    }

    @Override
    @Deprecated
    public String render(SoyTemplateInfo soyTemplateInfo, @Nullable Map<String, ?> map, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.renderMain(soyTemplateInfo.getName(), map == null ? null : new SoyMapData(map), null, null, soyMsgBundle, null, true);
    }

    @Override
    @Deprecated
    public String render(SoyTemplateInfo soyTemplateInfo, @Nullable SoyMapData soyMapData, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.renderMain(soyTemplateInfo.getName(), soyMapData, null, null, soyMsgBundle, null, true);
    }

    @Override
    @Deprecated
    public String render(String string, @Nullable Map<String, ?> map, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.renderMain(string, map == null ? null : new SoyMapData(map), null, null, soyMsgBundle, null, true);
    }

    @Override
    @Deprecated
    public String render(String string, @Nullable SoyMapData soyMapData, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.renderMain(string, soyMapData, null, null, soyMsgBundle, null, true);
    }

    private static class RendererImpl
    implements SoyTofu.Renderer {
        private final BaseTofu baseTofu;
        private final String templateName;
        private SoyMapData data;
        private SoyMapData ijData;
        private SoyMsgBundle msgBundle;
        private SoyCssRenamingMap cssRenamingMap;
        private Set<String> activeDelPackageNames;
        private boolean doAddToCache;

        public RendererImpl(BaseTofu baseTofu, String string) {
            this.baseTofu = baseTofu;
            this.templateName = string;
            this.data = null;
            this.ijData = null;
            this.activeDelPackageNames = null;
            this.msgBundle = null;
            this.cssRenamingMap = null;
            this.doAddToCache = true;
        }

        @Override
        public SoyTofu.Renderer setData(Map<String, ?> map) {
            this.data = map == null ? null : new SoyMapData(map);
            return this;
        }

        @Override
        public SoyTofu.Renderer setData(SoyMapData soyMapData) {
            this.data = soyMapData;
            return this;
        }

        @Override
        public SoyTofu.Renderer setIjData(Map<String, ?> map) {
            this.ijData = map == null ? null : new SoyMapData(map);
            return this;
        }

        @Override
        public SoyTofu.Renderer setIjData(SoyMapData soyMapData) {
            this.ijData = soyMapData;
            return this;
        }

        @Override
        public SoyTofu.Renderer setActiveDelegatePackageNames(Set<String> set) {
            this.activeDelPackageNames = set;
            return this;
        }

        @Override
        public SoyTofu.Renderer setMsgBundle(SoyMsgBundle soyMsgBundle) {
            this.msgBundle = soyMsgBundle;
            return this;
        }

        @Override
        public SoyTofu.Renderer setCssRenamingMap(SoyCssRenamingMap soyCssRenamingMap) {
            this.cssRenamingMap = soyCssRenamingMap;
            return this;
        }

        @Override
        public SoyTofu.Renderer setDontAddToCache(boolean bl) {
            this.doAddToCache = !bl;
            return this;
        }

        @Override
        public String render() {
            return this.baseTofu.renderMain(this.templateName, this.data, this.ijData, this.activeDelPackageNames, this.msgBundle, this.cssRenamingMap, this.doAddToCache);
        }
    }

    public static interface BaseTofuFactory {
        public BaseTofu create(SoyFileSetNode var1, boolean var2);
    }
}

