/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.xliffmsgplugin;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.IndentedLinesBuilder;
import com.google.template.soy.internal.base.CharEscaper;
import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import java.util.Map;
import javax.annotation.Nullable;

class XliffGenerator {
    private static final Map<String, String> CONTENT_TYPE_TO_XLIFF_DATATYPE_MAP = ImmutableMap.builder().put((Object)"text/plain", (Object)"plaintext").put((Object)"text/html", (Object)"html").put((Object)"application/xhtml+xml", (Object)"xhtml").put((Object)"application/javascript", (Object)"javascript").put((Object)"text/css", (Object)"css").put((Object)"text/xml", (Object)"xml").build();

    private XliffGenerator() {
    }

    static CharSequence generateXliff(SoyMsgBundle soyMsgBundle, String string, @Nullable String string2) {
        CharEscaper charEscaper = CharEscapers.xmlEscaper();
        CharEscaper charEscaper2 = CharEscapers.xmlContentEscaper();
        boolean bl = string2 != null && string2.length() > 0;
        IndentedLinesBuilder indentedLinesBuilder = new IndentedLinesBuilder(2);
        indentedLinesBuilder.appendLine("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        indentedLinesBuilder.appendLine("<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\">");
        indentedLinesBuilder.increaseIndent();
        indentedLinesBuilder.appendIndent().appendParts("<file original=\"SoyMsgBundle\" datatype=\"x-soy-msg-bundle\"", " xml:space=\"preserve\"", " source-language=\"", charEscaper.escape(string), "\"");
        if (bl) {
            indentedLinesBuilder.appendParts(" target-language=\"", charEscaper.escape(string2), "\"");
        }
        indentedLinesBuilder.append(">").appendLineEnd();
        indentedLinesBuilder.increaseIndent();
        indentedLinesBuilder.appendLine("<body>");
        indentedLinesBuilder.increaseIndent();
        for (SoyMsg soyMsg : soyMsgBundle) {
            Object object;
            Object object2;
            indentedLinesBuilder.appendIndent().appendParts("<trans-unit id=\"", Long.toString(soyMsg.getId()), "\"");
            String string3 = soyMsg.getContentType();
            if (string3 != null && string3.length() > 0) {
                object2 = CONTENT_TYPE_TO_XLIFF_DATATYPE_MAP.get(string3);
                if (object2 == null) {
                    object2 = string3;
                }
                indentedLinesBuilder.appendParts(" datatype=\"", charEscaper.escape((String)object2), "\"");
            }
            indentedLinesBuilder.append(">").appendLineEnd();
            indentedLinesBuilder.increaseIndent();
            indentedLinesBuilder.appendIndent().append("<source>");
            object2 = soyMsg.getParts().iterator();
            while (object2.hasNext()) {
                String string4;
                object = (SoyMsgPart)object2.next();
                if (object instanceof SoyMsgRawTextPart) {
                    string4 = ((SoyMsgRawTextPart)object).getRawText();
                    indentedLinesBuilder.append(charEscaper2.escape(string4));
                    continue;
                }
                string4 = ((SoyMsgPlaceholderPart)object).getPlaceholderName();
                indentedLinesBuilder.appendParts("<x id=\"", charEscaper.escape(string4), "\"/>");
            }
            indentedLinesBuilder.append("</source>").appendLineEnd();
            if (bl) {
                indentedLinesBuilder.appendLine("<target/>");
            }
            if ((object2 = soyMsg.getDesc()) != null && ((String)object2).length() > 0) {
                indentedLinesBuilder.appendLine("<note priority=\"1\" from=\"description\">", charEscaper2.escape((String)object2), "</note>");
            }
            if ((object = soyMsg.getMeaning()) != null && ((String)object).length() > 0) {
                indentedLinesBuilder.appendLine("<note priority=\"1\" from=\"meaning\">", charEscaper2.escape((String)object), "</note>");
            }
            indentedLinesBuilder.decreaseIndent();
            indentedLinesBuilder.appendLine("</trans-unit>");
        }
        indentedLinesBuilder.decreaseIndent();
        indentedLinesBuilder.appendLine("</body>");
        indentedLinesBuilder.decreaseIndent();
        indentedLinesBuilder.appendLine("</file>");
        indentedLinesBuilder.decreaseIndent();
        indentedLinesBuilder.appendLine("</xliff>");
        return indentedLinesBuilder;
    }
}

