/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.xliffmsgplugin;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.msgs.SoyMsgException;
import com.google.template.soy.msgs.SoyMsgPlugin;
import com.google.template.soy.xliffmsgplugin.XliffGenerator;
import com.google.template.soy.xliffmsgplugin.XliffParser;
import org.xml.sax.SAXException;

@Singleton
public class XliffMsgPlugin
implements SoyMsgPlugin {
    @Inject
    public XliffMsgPlugin() {
    }

    @Override
    public CharSequence generateExtractedMsgsFile(SoyMsgBundle soyMsgBundle, SoyMsgBundleHandler.OutputFileOptions outputFileOptions) throws SoyMsgException {
        return XliffGenerator.generateXliff(soyMsgBundle, outputFileOptions.getSourceLocaleString(), outputFileOptions.getTargetLocaleString());
    }

    @Override
    public SoyMsgBundle parseTranslatedMsgsFile(String string) throws SoyMsgException {
        try {
            return XliffParser.parseXliffTargetMsgs(string);
        }
        catch (SAXException sAXException) {
            throw new SoyMsgException(sAXException);
        }
    }
}

