/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.xliffmsgplugin;

import com.google.common.collect.Lists;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgException;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgBundleImpl;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XliffParser {
    private XliffParser() {
    }

    static SoyMsgBundle parseXliffTargetMsgs(String string) throws SAXException, SoyMsgException {
        SAXParser sAXParser;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AssertionError((Object)"Could not get SAX parser for XML.");
        }
        XliffSaxHandler xliffSaxHandler = new XliffSaxHandler();
        try {
            sAXParser.parse(new InputSource(new StringReader(string)), (DefaultHandler)xliffSaxHandler);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"Should not fail in reading a string.");
        }
        return new SoyMsgBundleImpl(xliffSaxHandler.getTargetLocaleString(), xliffSaxHandler.getMsgs());
    }

    private static class XliffSaxHandler
    extends DefaultHandler {
        private String targetLocaleString;
        private final List<SoyMsg> msgs = Lists.newArrayList();
        private boolean isInMsg = false;
        private long currMsgId;
        private List<SoyMsgPart> currMsgParts;
        private String currRawTextPart;

        public String getTargetLocaleString() {
            return this.targetLocaleString;
        }

        public List<SoyMsg> getMsgs() {
            return this.msgs;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string3.equals("file")) {
                if (this.targetLocaleString == null) {
                    this.targetLocaleString = attributes.getValue("target-language");
                } else if (!attributes.getValue("target-language").equals(this.targetLocaleString)) {
                    throw new SoyMsgException("If XLIFF input contains multiple 'file' elements, they must have the same 'target-language'.");
                }
            } else if (string3.equals("trans-unit")) {
                String string4 = attributes.getValue("id");
                try {
                    this.currMsgId = Long.parseLong(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SoyMsgException("Invalid message id '" + string4 + "' could not have been generated by the Soy compiler.");
                }
            } else if (string3.equals("target")) {
                this.currMsgParts = Lists.newArrayList();
                this.currRawTextPart = null;
                this.isInMsg = true;
            } else if (this.isInMsg) {
                if (!string3.equals("x")) {
                    throw new SoyMsgException("In messages extracted by the Soy compiler, all placeholders should be element 'x' (found element '" + string3 + "' in message).");
                }
                if (this.currRawTextPart != null) {
                    this.currMsgParts.add(new SoyMsgRawTextPart(this.currRawTextPart));
                    this.currRawTextPart = null;
                }
                this.currMsgParts.add(new SoyMsgPlaceholderPart(attributes.getValue("id")));
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (string3.equals("target")) {
                if (this.currRawTextPart != null) {
                    this.currMsgParts.add(new SoyMsgRawTextPart(this.currRawTextPart));
                    this.currRawTextPart = null;
                }
                this.isInMsg = false;
                if (this.currMsgParts.size() > 0) {
                    this.msgs.add(new SoyMsg(this.currMsgId, this.targetLocaleString, null, null, false, null, null, this.currMsgParts));
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (!this.isInMsg) {
                return;
            }
            this.currRawTextPart = this.currRawTextPart == null ? new String(cArray, n, n2) : this.currRawTextPart + new String(cArray, n, n2);
        }
    }
}

