(ns phalanges.dev
  (:require
   [figwheel.client :as fw :include-macros true]
   [weasel.repl :as ws-repl]
   [phalanges.core :as keyboard]
   [goog.events :as events]
   [goog.object :as object])
  (:import goog.events.EventType))

(defonce ws-repl-connection
  (ws-repl/connect "ws://localhost:9001" :verbose true))

(fw/watch-and-reload
  ;; :websocket-url "ws:localhost:3449/figwheel-ws" default
  :jsload-callback
  (fn [] (js/console.log (str (gensym "RELOAD"))))) 

(comment
  (def test-area
    (js/document.getElementById "test"))

  (listen-sequence! test-area
                    [#{:a} #{:b} #{:c}]
                    #(js/console.log "foo"))

  (listen-sequence! test-area
                    [#{:a :shift} #{:b} #{:c}]
                    #(js/console.log "bar"))

  (listen-sequence! test-area
                    [#{:a :shift} #{:b :shift} #{:c}]
                    #(js/console.log "baz"))

  (unlisten-sequence! test-area [#{:a} #{:b} #{:c}]))
