(ns leiningen.new.splat
  (:require [clojure.java.io :as io]
            [leiningen.new.templates :refer [renderer name-to-path ->files]]))

(def render (renderer "splat"))

(defn splat
  "Create a new CLJS Single Page Application"
  [name]
  (println "Creating a new CLJS Single Page Application...")
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
             ["project.clj" (render "project.clj" data)]
             [".gitignore" (render "gitignore" data)]
             ["resources/{{name}}-config.edn" (render "resources/config.edn" data)]
             
             ["src/clojure/{{sanitized}}/handler.clj" (render "clj/handler.clj" data)]
             ["src/cljs/{{sanitized}}/cljs/app.cljs" (render "cljs/app.cljs" data)]
             ["externs/jquery.js" (render "externs/jquery.js")]
             "target/resources"
             "target/generated/clj"
             "target/generated/cljs"
             "src/cljx/{{name}}/cljx"))
  (println "Created!")
  (println "You can run the application with `lein dev`"))
