



(import java.util.ArrayList
        java.util.concurrent.ConcurrentLinkedQueue
        (javafx.animation AnimationTimer)
        (javafx.beans.property DoubleProperty SimpleDoubleProperty)
        (javafx.geometry Bounds Orientation VPos)
        (javafx.scene.canvas Canvas GraphicsContext)
        (javafx.scene.control Button Label ScrollBar ScrollPane ScrollPane$ScrollBarPolicy)
        (javafx.scene.layout BorderPane Priority StackPane)
        (javafx.scene.paint Color)
        (javafx.scene.shape Rectangle StrokeType)
        (javafx.scene.text Font FontSmoothingType Text)
        )

(def ^ConcurrentLinkedQueue text-pool (ConcurrentLinkedQueue. (repeatedly 20000 #(Text.))))

(defprotocol CodePaneP
  "Objects that can be shown on a javafx.stage.Stage."
  (get-x [cp])
  (get-y [cp])
  (paint [obj]))

;; A PooledText is a wrapper of a JFX Text component that can be painted on a Sky.
;;;;; creator => function that takes a Text and returns it, modified
;; text => a text String, typically contains code.
;; minx/miny => minx/miny coordinates in the Sky on which the component should be painted
;; maxx/maxy => maxx/maxy coordinates in the Sky on which the component should be painted
(defrecord CachedText [text bounds font fill text-instance])

(def visible-cts (ConcurrentLinkedQueue.))

(defn create-cache-text [^String s, x, y, ^Font font, ^Color fill]
  (let [^Text t (or (.poll text-pool) (Text.))]
    (.setText t s)
    (.setX t x)
    (.setY t y)
    (.setFont t font)
    (.setFill t fill)
    (.add text-pool t)
    (CachedText. s
                 (.getLayoutBounds t)
                 font fill
                 (atom nil))))

(def paint-counter (atom (long 0)))

;; A CodePane is a virtual pane on which contents can be painted.
;; One can get a viewport into a Sky which will realize/initiate an
;; actual painting of components.
;; A Sky can be used as a code editor, or as a container for Clouds (i.e. “bubbles”)
;;;;; creators => ArrayList of Creators
;; clouds => ArrayList of JFX Nodes or PooledTexts
;; wmax/hmax => max width/height
;;              although the Sky is infinite, this is the max value.
;;              IF a monitor were big enough, then in principle the
;;              whole Sky could be fully visible.
;; Viewport: x/y/width/height
;;   A rectengular viewport into the Sky, at coordinates x/y with
;;   the corresponding width/height. If a monitor is big enough, then
;;   x/y could be 0 and width/height = vmax/hmax.
;; Note: if you want to create several components on top of each other,
;; then add the Contents in the order in which you want them to get painted.
(deftype CodePane
    [^BorderPane root
     ^Pane pane
     ;;^ArrayList nodes
     nodes
     ;;visibles
     ;;not-visible-anymore
     ^ScrollBar hbar
     ^ScrollBar vbar
     ^DoubleProperty width
     ^DoubleProperty height
     ]
  CodePaneP
  (get-x [cp]
    (.getValue hbar))
  (get-y [cp]
    (.getValue vbar))
  #_(paint [cp]
      (let [x (get-x cp)
            y (get-y cp)
            w (.getWidth pane)
            h (.getHeight pane)
            nodes2 @nodes
            visibles (atom (:visible nodes2))
            non-visibles (atom (:non-visible nodes2))
            not-visible-anymore (atom (:not-visible-anymore nodes2))]
        ;; zuerst durch alle sichtbaren gehen, und diese verschieben
        ;; oder in die nicht-mehr-sichtbar-Liste verschieben
        (doseq [ct @visibles]
          (let [^Bounds bounds (:bounds ct)
                minx (.getMinX bounds)
                miny (.getMinY bounds)]
            (if (.intersects bounds x y w h)
              ;; noch immer sichtbar:
              (.relocate ^Text @(:text-instance ct)
                         (- minx x) (- miny y))
              ;; nicht mehr sichtbar
              (let [^Text t @(:text-instance ct)]
                (reset! (:text-instance ct) nil)
                (swap! not-visible-anymore conj ct)
                (swap! visibles disj ct)
                (.remove (.getChildren pane) t)
                (.add text-pool t)))))
        ;; nun durch alle verbliebenen durchmarschieren:
        (doseq [ct @non-visibles]
          ;; a ct must be painted if at least a single pixel of its
          ;; rectangular bounds are in the CodePane’s viewport:
          (let [^Bounds bounds (:bounds ct)]
            (when (.intersects bounds x y w h)
              (swap! visibles conj ct)
              (swap! non-visibles disj ct)
              (let [^Text t (or (.poll text-pool) (Text.))]
                (reset! (:text-instance ct) t)
                (.setText t (:text ct))
                (.setX t (- (.getMinX bounds) x))
                (.setY t (- (.getMinY bounds) y))
                (.setFont t (:font ct))
                (.setFill t (:fill ct))
                (add pane t)))))
        ;; die nicht-sichtbaren wieder zu den Nodes packen
        (let [nva @not-visible-anymore]
          (when (seq nva)
            (reset! not-visible-anymore #{})
            (apply swap! non-visibles conj nva)))
        (reset! nodes {:non-visible @non-visibles
                       :visible @visibles
                       :not-visible-anymore @not-visible-anymore})))
  (paint [cp]
    (let [pc @paint-counter
          x (get-x cp)
          y (get-y cp)
          w (.getWidth pane)
          h (.getHeight pane)
          temp (atom #{})          
          ]
      #_(doseq [^CachedText ct nodes]
        ;; a ct must be painted if at least a single pixel of its
        ;; rectangular bounds are in the CodePane’s viewport:
        (let [^Bounds bounds (:bounds ct)
              ti (:text-instance ct)
              ^Text t (and ti @ti)]
          (if-not (try (.intersects bounds x y w h) (catch Exception e (println "nanje4" ct bounds x y w h)))
            (when t
              (try (.remove (.getChildren pane) t)
                   (catch Exception e (println "nobe1")))
              (swap! temp conj t)
              (reset! (:text-instance ct) nil))
            (if t
              (try (.relocate t (- (.getMinX bounds) x) (- (.getMinY bounds) y))
                   (catch Exception e (println "nobe2")))
              (let [^Text t (or (.poll text-pool) (Text.))]
                (reset! (:text-instance ct) t)
                (try
                  (.setText t (:text ct))
                  (.setFont t (:font ct))
                  (.setFill t (:fill ct))
                  #_(.setFontSmoothingType t FontSmoothingType/LCD)
                  (.relocate t (- (.getMinX bounds) x) (- (.getMinY bounds) y))
                  (add pane t)
                  (catch Exception e (println "nobe3")))
                )))))
      (loop [ns nodes
             ^CachedText ct (first ns)]
        (when (and ct)
          #_(and ct (= pc @paint-counter))
          (if (not= pc @paint-counter)
            (println "aus")            
            ;; a ct must be painted if at least a single pixel of its
            ;; rectangular bounds are in the CodePane’s viewport:
            (let [^Bounds bounds (:bounds ct)
                  ti (:text-instance ct)
                  ^Text t (and ti @ti)]
              (if-not (try (.intersects bounds x y w h) (catch Exception e (println "nanje4" ct bounds x y w h)))
                (when t
                  (try (.remove (.getChildren pane) t)
                       (catch Exception e (println "nobe1")))
                  (swap! temp conj t)
                  (reset! (:text-instance ct) nil))
                (if t
                  (try (.relocate t (- (.getMinX bounds) x) (- (.getMinY bounds) y))
                       (catch Exception e (println "nobe2")))
                  (let [^Text t (or (.poll text-pool) (Text.))]
                    (reset! (:text-instance ct) t)
                    (try
                      (.setText t (:text ct))
                      (.setFont t (:font ct))
                      (.setFill t (:fill ct))
                      #_(.setFontSmoothingType t FontSmoothingType/LCD)
                      (.relocate t (- (.getMinX bounds) x) (- (.getMinY bounds) y))
                      (add pane t)
                      (catch Exception e (println "nobe3")))
                    )))))
          (recur (rest ns) (first (rest ns)))))
      (doseq [t @temp]
        (.add text-pool t))))
  Showable
  (show* [cd stage]
    (show* (.root cd) stage)
    (paint cd)))

(defn create-code-pane []
  (let [root (BorderPane.)
        pane (Pane.)
        pane-width (.widthProperty pane)
        pane-height (.heightProperty pane)
        lbp (.layoutBoundsProperty pane)
        bounds (.getLayoutBounds pane)
        width (.getWidth bounds)
        height (.getHeight bounds)
        hbar (ScrollBar.)
        vbar (ScrollBar.)
        vbar-pos (.valueProperty vbar)
        vbar-max (.maxProperty vbar)
        width (SimpleDoubleProperty. 0.0)
        height (SimpleDoubleProperty. 0.0)
        cp (CodePane. root pane
                      (ArrayList.)
                      #_(atom {:non-visible #{}
                             :visible #{}
                             :not-visible-anymore #{}})
                      hbar vbar
                      width height)]
    (defbinding (.maxHeightProperty pane) [height]
      (.get height))
    (defbinding (.maxProperty hbar) [pane-width]
      (.get pane-width))
    ;; vertical ScrollBar
    (.setOrientation vbar Orientation/VERTICAL)
    ;; max value (position) of the thumb of the vbar
    (defbinding vbar-max [pane-height height]
      (max 0 (- (.get height) (.get pane-height))))
    ;; amount of pixels to move, when the thumb is clicked
    (defbinding (.unitIncrementProperty vbar) [vbar-max]
      (/ (.get vbar-max) 21.0))
    ;; amount of pixels to move, when the track is clicked
    (defbinding (.blockIncrementProperty vbar) [vbar-max]
      (/ (.get vbar-max) 10.0))
    ;; size of the thumb
    (defbinding (.visibleAmountProperty vbar) [vbar-max pane-height height]
      (* (.get vbar-max) (/ (.get pane-height) (.get height))))
    (.addListener vbar-pos
                  (reify javafx.beans.value.ChangeListener
                    (changed [this observable old new]
                      (swap! paint-counter inc)
                      (paint cp))))
    #_(.addListener pane-height
                    (reify javafx.beans.value.ChangeListener
                      (changed [this observable old new]
                        (let [diff (- new old)]
                          #_(println (format "diff = %s (new-old = %s-%s)" diff new old))
                          (if (neg? diff)
                            (.setValue vbar (- (.getValue vbar) diff))
                            #_(.setValue vbar (max 0 (- (.getValue vbar) diff)))))
                        (paint cp))))
    (.setCenter root pane)
    (.setBottom root hbar)
    (.setRight root vbar)
    (let [top (HBox.)
          l1 (Label.)
          l2 (Label.)
          old (atom (System/nanoTime))
          timer (atom @old)
          counter (atom -1)
          at (proxy [AnimationTimer] []
               (handle [now]
                 (swap! counter inc)
                 (.setText l2 (format "Time: %.2f" (/ (- now @timer) 1000000000.0)))
                 (when (> (- now @old) 1000000000)
                   (.setText l1 (str "FPS: " @counter))
                   (reset! counter -1)
                   (reset! old now))))]
      #_(defbinding (.textProperty l1) [height pane-height vbar-pos vbar-max (.visibleAmountProperty vbar)]
        (format "CPH: %g / PaneH: %g /\n BarPos: %g / BarH: %g / Thumb: %g"
                (.get height)
                (.get pane-height)
                (.get vbar-pos)
                (.get vbar-max)
                (.get (.visibleAmountProperty vbar))))
      (.start at)
      (.setTop root top)
      (def ^AnimationTimer kronos at)
      (add top l1)
      (add top l2))
    cp))

#_(defn get-x [^CodePane cp]
  (.getValue ^ScrollBar (.hbar cp)))

#_(defn get-y [^CodePane cp]
  (.getValue ^ScrollBar (.vbar cp)))

(defn get-cp-bounds [^CodePane cp]
  [(get-x cp) (get-y cp)
   (.get ^DoubleProperty (.width cp))
   (.get ^DoubleProperty (.height cp))])

#_(defn add-content [^CodePane cp, ^Node node]
  (let [^ArrayList nodes (.nodes cp)
        ^DoubleProperty width  (.width cp)
        ^DoubleProperty height (.height cp)
        w (.get width)
        h (.get height)
        bounds (.getLayoutBounds node)
        maxx   (.getMaxX bounds)
        maxy   (.getMaxY bounds)]
    (.add nodes node)
    (when (> maxx w)
      (.set width maxx))
    (when (> maxy h)
      (.set height maxy))))

(defn add-text-content [^CodePane cp, cached-text]
  (let [^ArrayList nodes (.nodes cp)
        ^DoubleProperty width  (.width cp)
        ^DoubleProperty height (.height cp)
        w (.get width)
        h (.get height)
        ^Bounds bounds (:bounds cached-text)
        maxx (.getMaxX bounds)
        maxy (.getMaxY bounds)]
    #_(swap! nodes update-in [:non-visible] conj cached-text)
    (.add nodes cached-text)
    (when (> maxx w)
      (.set width maxx))
    (when (> maxy h)
      (.set height maxy))))

#_(defn paint [^CodePane cp]
    (let [^Pane pane (.pane cp)
        x (get-x cp)
        y (get-y cp)
        w (.getWidth pane)
        h (.getHeight pane)]
    #_(println (format "Paint: %6g / %6g / %6g / %6g" x y w h))
    (doseq [^Node node (.nodes cp)]
      (let [bounds (.getLayoutBounds node)
            minx   (.getMinX bounds)
            miny   (.getMinY bounds)]
        #_(println (format "Node: %6g / %6g" minx miny) (.intersects bounds x y w h))
        ;; a node must be painted if at least a single pixel of its
        ;; rectangular bounds are in the CodePane’s viewport:
        (if-not (.intersects bounds x y w h)
          (jfx
           (.setUserData node nil)
           (.remove (.getChildren pane) node))
          (jfx
           (when-not (.getUserData node)
             (add pane node)
             (.setUserData node true))
           (.relocate node (- minx x) (- miny y))))))))

#_(defn foo []
  (let [^CodePane cp (create-code-pane)
        ^BorderPane root (.root cp)
        ^Pane p (.pane cp)
        texte [(Text. 50 150 "Text 1")
               (Text. 50 450 "Text 2")
               (Text. 20 500 "Text 3")
               (Text. 70 950 "Text 4")]
        ]
    (.setStyle p "-fx-background-color: #336699;") ;
    (let [fons 12.0
          fon (Font. "Droid Sans Mono" fons)
          ws (Text. " ")
          _ (.setFont ws fon)
          wws (.getWidth (.getLayoutBounds ws))
          hws (.getHeight (.getLayoutBounds ws))
          next-x (atom 0.0)
          next-y (atom hws)
          counter (atom -1)]
      (doseq [^String s (map str (range 1 8001))]
        (let [t (Text. (double @next-x) (double @next-y) s)
              _ (.setFont t fon)
              ;;_ (.setFontSmoothingType t FontSmoothingType/LCD)
              _ (.setFill t (Color. (rand) (rand) (rand) 1.0))
              lbw (.getWidth (.getLayoutBounds t))]
          (add-content cp t)
          (swap! next-x + lbw wws)
          (when (zero? (mod (swap! counter inc) 20))
            (reset! next-x 0)
            (swap! next-y + hws)))))
    ;; root BorderPane
    (.setPrefSize root 350 650)
    ;; vertical ScrollBar
    (def cope cp)
    (def scro (.vbar cp))
    #_(doseq [t texte]
      (add-content cp t)
      #_(println "Neue Bounds:" (get-cp-bounds cp)))
    #_(println "Bounds:" (get-cp-bounds cp))
    (show cp)
    ;;(paint sky)
    ))

;; (foo)

(defn setup-text [^Text t]
  (.setFont t (Font. "Droid Sans" 12))
  ;;(.setFont t1 (Font. "Calibri" font-size))
  (.setFill t Color/BLACK)
  (.setFontSmoothingType t FontSmoothingType/LCD)
  t)


(defn bar []
  (let [^CodePane cp (create-code-pane)
        ^BorderPane root (.root cp)
        ^Pane p (.pane cp)
        fons 12.0
        fon (Font. "Droid Sans Mono" fons)
        col Color/DARKVIOLET
        texte [(create-cache-text "Text 1" 50 150 fon col)
               (create-cache-text "Text 2" 50 450 fon col)
               (create-cache-text "Text 3" 20 500 fon col)
               (create-cache-text "Text 4" 70 830 fon col)
               ]
        ]
    (let [ws (Text. " ")
          _ (.setFont ws fon)
          wws (.getWidth (.getLayoutBounds ws))
          hws (.getHeight (.getLayoutBounds ws))
          next-x (atom 0.0)
          next-y (atom hws)
          counter (atom -1)]
      (doseq [^String s (map str (range 1 100001))]
        (let [ct (create-cache-text s @next-x @next-y fon col)
              ;;_ (.setFontSmoothingType t FontSmoothingType/LCD)
              lbw (.getWidth ^Bounds (:bounds ct))]
          (add-text-content cp ct)
          (swap! next-x + lbw wws)
          (when (zero? (mod (swap! counter inc) 20))
            (reset! next-x 0)
            (swap! next-y + hws)))))
    ;; root BorderPane
    (.setPrefSize root 350 650)
    ;; vertical ScrollBar
    (def ^CodePane cope cp)
    (def ^ScrollBar scro (.vbar cp))
    (show cp)
    ))

;; (bar)

;; (.stop kronos)   (count text-pool)
