(ns splendid.ml.nb
  (:use splendid.ml.text))

(defn classify [nb data]
  (let [extract-features (:extraction-fn nb)
        features (extract-features data)
        ]
    )
  )

(let [slen 2500
      per-substring 35
      per-clojure 65
      per-word (+ per-substring per-clojure)
      words 500
      per-text (/ (+ slen (* words per-word))
                  1024.0)
      texts 1000]
  (/ (* texts per-text) 1024.0)
  )


(use 'calx)

(def source
  "__kernel void square (
       __global const float *a,
       __global float *b) {
    int gid = get_global_id(0);
    b[gid] = a[gid] * a[gid];
  }")

#_
(with-cl
  (with-program (compile-program source)
    (let [a (wrap [1 2 3] :float32-le)
          b (mimic a)]
      (enqueue-kernel :square 3 a b)
      (enqueue-read b))))