(ns splendid.ml.plotter
  (:import (javax.swing JFrame JPanel)
           (net.ericaro.surfaceplotter JSurfacePanel Mapper ProgressiveSurfaceModel)))

(set! *warn-on-reflection* false)
(use '(incanter core charts))
(require '[incanter.stats :as stats])
(set! *warn-on-reflection* true)

(defn plot
  "Plots one or two functions `fn1`, `fn2` which must take exactly two
  (real valued) arguments."
  ([fn1] (plot fn1 nil))
  ([fn1 fn2]
     (let [jf (JFrame. "3D surface")
           sp (JSurfacePanel.)
           psm (ProgressiveSurfaceModel.)
           fn2 (or fn2 (constantly 0))
           mapper (reify Mapper
                    (f1 [this x y] (fn1 x y))
                    (f2 [this x y] (fn2 x y)))]
       (.setTitleText sp "3D surface")
       (.setModel sp psm)
       (.setMapper psm mapper)
       (.. jf getContentPane (add sp))
       (.. psm plot execute)
       (.pack jf)
       (.setSize jf 800 600)
       (.setLocationRelativeTo jf nil)
       (.setVisible jf true)
       (.toFront jf)
       [jf sp psm])))
