(ns ring.middleware.ostrich
  "Provide Ostrich stats."
  (:import com.twitter.ostrich.admin.AdminHttpService
           com.twitter.finagle.stats.OstrichStatsReceiver))

(defn wrap-ostrich [app path]
  (fn [req]
    (if (= (:uri req) path)
      {:status 200
       :headers {"Content-Type" "application/json"}
       :body (.toJson com.twitter.ostrich.stats.Stats$/MODULE$)}
      (app req))))
