(ns leiningen.new.sqweb
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "sqweb"))

(defn sqweb
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data ["src/{{sanitized}}/util.clj" (render "util.clj" data)]
["project.clj" (render "project.clj" data)]
["src/{{sanitized}}/layout.clj" (render "layout.clj" data)]
["src/{{sanitized}}/session_manager.clj" (render "session_manager.clj" data)]
["src/{{sanitized}}/routes/home.clj" (render "home.clj" data)]
["test/{{sanitized}}/test/handler.clj" (render "handler.clj" data)]
["src/{{sanitized}}/repl.clj" (render "repl.clj" data)]
["src/{{sanitized}}/handler.clj" (render "handler.clj" data)]
["src/{{sanitized}}/middleware.clj" (render "middleware.clj" data)]
["resources/public/css/screen.css" (render "screen.css")]
["resources/templates/base.html" (render "base.html")]
["resources/public/md/docs.md" (render "docs.md")]
["resources/public/fonts/glyphicons-halflings-regular.woff" (render "glyphicons_halflings_regular.woff")]
["resources/public/fonts/glyphicons-halflings-regular.svg" (render "glyphicons_halflings_regular.svg")]
["resources/public/fonts/glyphicons-halflings-regular.ttf" (render "glyphicons_halflings_regular.ttf")]
["resources/templates/home.html" (render "home.html")]
["resources/public/fonts/glyphicons-halflings-regular.eot" (render "glyphicons_halflings_regular.eot")]
["resources/templates/about.html" (render "about.html")]
)))