(ns srnp.mailbox.client
  "Client for the SRNP mailbox web service."
  (:use [environ.core :only (env)])
  (:require [indolent.client :as client]
            [clj-time.format :as time]))

(defn- parse-date [date]
  (if date
    (time/parse (time/formatters :date-time-no-ms) date)))

(defn list-messages
  "Retrieve a list of messages for the supplied recipient."
  ([recipient]
     (list-messages (env :srnp-mailbox-url) recipient))
  ([service recipient]
     (->> (client/get [service recipient])
          (map #(update-in % [:modified] parse-date)))))
