(ns srnp.metadata.client
  "Client for the SRNP metadata web service."
  (:use [environ.core :only (env)])
  (:require [clj-http.client :as http]
            [ring.util.codec :as codec]))

(defn- response-body [resp]
  (if (= 200 (:status resp))
    (:body resp)))

(defn resource-metadata
  "Retrieve metadata for a HTTP resource."
  ([resource-url]
     (resource-metadata (env :srnp-metadata-url) resource-url))
  ([service-url resource-url]
     (response-body
      (http/get
       (str service-url "/" (codec/url-encode resource-url))
       {:as :json}))))
