(ns common.db.migrate
  "Database migrations management alternative main/entry-point.
  This is runnable using `lein run -m common.db.migrate` or compiled using
  `java -cp uberjar.jar common.db.migrate`. See usage below for more details."
  (:require
    [clams.conf :as conf]
    [clj-time.core :refer [now]]
    [clj-time.format :as tf]
    [clojure.string :refer [upper-case]]
    [clojure.tools.logging :as log]
    [common.convert :refer [str->int]]
    [monger.core :as mg]
    [monger.ragtime :as mr]
    [ragtime.jdbc :as jdbc]
    [ragtime.repl :as repl]
    [resauce.core :as resauce])
  (:import
   [java.io File])
  (:gen-class))

(def ^:private config
  {:database (conf/get :database-jdbc-url)
   :migrations (jdbc/load-resources (conf/get :migrations-dir "migrations"))})

(def usage
  "Manage database migrations.

Usage: lein run -m common.db.migrate <COMMAND> <ARGS>

Commands:
  migrate           Migrate to the latest version
  rollback [n]      Rollback n versions (defaults to 1)")

(defn -main
  "Run the migrations or rollbacks"
  [& args]
  (case (first args)
    "migrate" (repl/migrate config)
    "rollback" (repl/rollback config (if-let [n (second args)]
                                       (str->int n)
                                       1))
    (do (println usage)
        (System/exit 1))))
