(ns ant-ui.fx
  "This namespace provides `re-frame` fx to trigger/hide messages. To use, just
  require it from your application's `core` (or whatever the entrypoint is)
  namespace."
  (:require [re-frame.core :refer [reg-fx dispatch]]
            cljsjs.antd))

;; =============================================================================
;; Message: https://ant.design/components/message/

(def message (.-message js/window.antd))

(def loading (atom nil))

(defn- hide! [& _]
  (when-let [hide @loading]
    (hide)))

(defn- remember! [f]
  (hide!)
  (reset! loading f))

(reg-fx
 :alert/message
 (fn [{:keys [type content duration]
       :or   {type :info duration 1.5}}]
   (assert content "`:content` must be provided!")
   (remember!
    (if (= duration :indefinite)
      ((aget message (name type)) content 0)
      ((aget message (name type)) content duration)))))

(reg-fx
 :alert.message/hide
 hide!)


;; =============================================================================
;; Notification: https://ant.design/components/message/

(def notification (.-notification js/window.antd))

(reg-fx
 :alert/notify
 (fn [{:keys [type title content duration key on-close]
       :or   {type :info duration 5}}]
   (assert (and title content) "`:title` and `:content` must be provided!")
   (let [f (aget notification (name type))]
     (f #js {:message     title
             :description content
             :duration    (if (= duration :indefinite) 0 duration)
             :key         key
             :on-close    (fn [] (dispatch on-close))}))))

(reg-fx
 :alert.notify/hide
 (fn [key]
   (.close notification key)))
