/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.util.Map;
import org.httpkit.DynamicBytes;

public interface IFilter {
    public static final IFilter ACCEPT_ALL = new IFilter(){

        @Override
        public boolean accept(DynamicBytes partialBody) {
            return true;
        }

        @Override
        public boolean accept(Map<String, String> headers) {
            return true;
        }

        public String toString() {
            return "Response Filter: ACCEPT all response";
        }
    };

    public boolean accept(Map<String, String> var1);

    public boolean accept(DynamicBytes var1);

    public static class MaxBodyFilter
    implements IFilter {
        private final int length;

        public MaxBodyFilter(int maxLength) {
            this.length = maxLength;
        }

        @Override
        public boolean accept(Map<String, String> headers) {
            return true;
        }

        public String toString() {
            return "Response Filter: ACCEPT when body's length <= " + this.length;
        }

        @Override
        public boolean accept(DynamicBytes partialBody) {
            return partialBody.length() <= this.length;
        }
    }
}

