/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Map;
import org.httpkit.BytesInputStream;
import org.httpkit.HttpMethod;
import org.httpkit.HttpVersion;
import org.httpkit.server.AsyncChannel;

public class HttpRequest {
    public final String queryString;
    public final String uri;
    public final HttpMethod method;
    public final HttpVersion version;
    private byte[] body;
    int serverPort = 80;
    String serverName;
    Map<String, String> headers;
    int contentLength = 0;
    String contentType;
    String charset = "utf8";
    boolean isKeepAlive = false;
    boolean isWebSocket = false;
    InetSocketAddress remoteAddr;
    AsyncChannel channel;

    public HttpRequest(HttpMethod method, String url, HttpVersion version) {
        this.method = method;
        this.version = version;
        int idx = url.indexOf(63);
        if (idx > 0) {
            this.uri = url.substring(0, idx);
            this.queryString = url.substring(idx + 1);
        } else {
            this.uri = url;
            this.queryString = null;
        }
    }

    public InputStream getBody() {
        if (this.body != null) {
            return new BytesInputStream(this.body, this.contentLength);
        }
        return null;
    }

    public String getRemoteAddr() {
        String h = this.headers.get("x-forwarded-for");
        if (null != h) {
            int idx = h.indexOf(44);
            if (idx == -1) {
                return h;
            }
            return h.substring(0, idx);
        }
        return this.remoteAddr.getAddress().getHostAddress();
    }

    public void setBody(byte[] body, int count) {
        this.body = body;
        this.contentLength = count;
    }

    public void setHeaders(Map<String, String> headers) {
        String con;
        String ct;
        String h = headers.get("host");
        if (h != null) {
            int idx = h.lastIndexOf(58);
            if (idx != -1) {
                this.serverName = h.substring(0, idx);
                this.serverPort = Integer.valueOf(h.substring(idx + 1));
            } else {
                this.serverName = h;
            }
        }
        if ((ct = headers.get("content-type")) != null) {
            int idx = ct.indexOf(";");
            if (idx != -1) {
                int cidx = ct.indexOf("charset=", idx);
                if (cidx != -1) {
                    this.contentType = ct.substring(0, idx);
                    this.charset = ct.substring(cidx + "charset=".length());
                } else {
                    this.contentType = ct;
                }
            } else {
                this.contentType = ct;
            }
        }
        if ((con = headers.get("connection")) != null) {
            con = con.toLowerCase();
        }
        this.isKeepAlive = this.version == HttpVersion.HTTP_1_1 && !"close".equals(con) || "keep-alive".equals(con);
        this.isWebSocket = "websocket".equalsIgnoreCase(headers.get("upgrade"));
        this.headers = headers;
    }
}

