/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Set;

public class NIOPerfTest {
    private final Selector selector;
    private final ServerSocketChannel serverChannel;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
    final int LNEGHT = 1500;
    private final ByteBuffer output = ByteBuffer.allocate(65536);
    String header = "HTTP/1.1 200 OK\r\nConnection: Keep-Alive\r\nDate: Fri, 12 Apr 2013 05:24:18 GMT\r\nContent-Length:1500\r\n\r\n";
    String body = "";
    byte[] headerBytes = this.header.getBytes();
    byte[] bodyBytes;

    public NIOPerfTest() throws IOException {
        this.selector = Selector.open();
        for (int i = 0; i < 150; ++i) {
            this.body = this.body + "1234567890";
        }
        this.bodyBytes = this.body.getBytes();
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        InetSocketAddress addr = new InetSocketAddress("0.0.0.0", 8000);
        this.serverChannel.socket().bind(addr);
        this.serverChannel.register(this.selector, 16);
    }

    public void run() throws IOException {
        while (true) {
            int select;
            if ((select = this.selector.select()) <= 0) {
                continue;
            }
            Set<SelectionKey> selectionKeys = this.selector.selectedKeys();
            for (SelectionKey key : selectionKeys) {
                SocketChannel ch;
                if (!key.isValid()) continue;
                if (key.isAcceptable()) {
                    SocketChannel s = this.serverChannel.accept();
                    if (s == null) continue;
                    s.configureBlocking(false);
                    s.register(this.selector, 1);
                    continue;
                }
                if (key.isReadable()) {
                    try {
                        this.buffer.clear();
                        ch = (SocketChannel)key.channel();
                        int read = ch.read(this.buffer);
                        if (read < 0) {
                            key.channel().close();
                            System.out.printf("closed\n", new Object[0]);
                            continue;
                        }
                        if (read > 0) {
                            this.output.clear();
                            this.output.put(this.headerBytes).put(this.bodyBytes);
                            this.output.flip();
                            ch.write(this.output);
                            if (!this.output.hasRemaining()) continue;
                            System.out.println("=============");
                            key.interestOps(4);
                            continue;
                        }
                        System.out.println(key);
                    }
                    catch (IOException e) {
                        key.channel().close();
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!key.isWritable()) continue;
                ch = (SocketChannel)key.channel();
                try {
                    this.output.clear();
                    this.output.put(this.headerBytes).put(this.bodyBytes);
                    this.output.flip();
                    ch.write(this.output);
                    key.interestOps(1);
                }
                catch (IOException e) {
                    key.channel().close();
                    e.printStackTrace();
                }
            }
            selectionKeys.clear();
        }
    }

    public static void main(String[] args) throws IOException {
        new NIOPerfTest().run();
    }
}

