/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;
import org.httpkit.HttpMethod;
import org.httpkit.HttpStatus;
import org.httpkit.HttpUtils;
import org.httpkit.HttpVersion;
import org.httpkit.LineReader;
import org.httpkit.LineTooLargeException;
import org.httpkit.ProtocolException;
import org.httpkit.client.AbortException;
import org.httpkit.client.IRespListener;
import org.httpkit.client.State;

public class Decoder {
    private final Map<String, String> headers = new TreeMap<String, String>();
    final IRespListener listener;
    private final LineReader lineReader;
    int readRemaining = 0;
    State state = State.READ_INITIAL;
    private final HttpMethod method;
    private boolean emptyBodyExpected = false;

    public Decoder(IRespListener listener, HttpMethod method) {
        this.listener = listener;
        this.method = method;
        this.lineReader = new LineReader(8096);
    }

    private void parseInitialLine(String sb) throws ProtocolException, AbortException {
        int cEnd;
        int aStart = HttpUtils.findNonWhitespace(sb, 0);
        int aEnd = HttpUtils.findWhitespace(sb, aStart);
        int bStart = HttpUtils.findNonWhitespace(sb, aEnd);
        int bEnd = HttpUtils.findWhitespace(sb, bStart);
        int cStart = HttpUtils.findNonWhitespace(sb, bEnd);
        if (cStart < (cEnd = HttpUtils.findEndOfString(sb)) || cStart == cEnd && bStart < bEnd) {
            try {
                int status = Integer.parseInt(sb.substring(bStart, bEnd));
                this.emptyBodyExpected = status / 100 == 1 || status == 204 || status == 304;
                HttpStatus s = HttpStatus.valueOf(status);
                HttpVersion version = HttpVersion.HTTP_1_1;
                if ("HTTP/1.0".equals(sb.substring(aStart, aEnd))) {
                    version = HttpVersion.HTTP_1_0;
                }
                this.listener.onInitialLineReceived(version, s);
                this.state = State.READ_HEADER;
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("not http protocol? " + sb);
            }
        } else {
            throw new ProtocolException("not http protocol? " + sb);
        }
    }

    public State decode(ByteBuffer buffer) throws LineTooLargeException, ProtocolException, AbortException {
        while (buffer.hasRemaining() && this.state != State.ALL_READ) {
            switch (this.state) {
                case READ_INITIAL: {
                    String line = this.lineReader.readLine(buffer);
                    if (line == null) break;
                    this.parseInitialLine(line);
                    break;
                }
                case READ_HEADER: {
                    this.readHeaders(buffer);
                    break;
                }
                case READ_CHUNK_SIZE: {
                    String line = this.lineReader.readLine(buffer);
                    if (line == null || line.isEmpty()) break;
                    this.readRemaining = HttpUtils.getChunkSize(line);
                    if (this.readRemaining == 0) {
                        this.state = State.READ_CHUNK_FOOTER;
                        break;
                    }
                    this.state = State.READ_CHUNKED_CONTENT;
                    break;
                }
                case READ_FIXED_LENGTH_CONTENT: {
                    this.readBody(buffer, State.ALL_READ);
                    break;
                }
                case READ_CHUNKED_CONTENT: {
                    this.readBody(buffer, State.READ_CHUNK_DELIMITER);
                    break;
                }
                case READ_CHUNK_FOOTER: {
                    this.readEmptyLine(buffer);
                    this.state = State.ALL_READ;
                    break;
                }
                case READ_CHUNK_DELIMITER: {
                    this.readEmptyLine(buffer);
                    this.state = State.READ_CHUNK_SIZE;
                    break;
                }
                case READ_VARIABLE_LENGTH_CONTENT: {
                    this.readBody(buffer, null);
                }
            }
        }
        return this.state;
    }

    private void readBody(ByteBuffer buffer, State nextState) throws AbortException {
        int toRead = Math.min(buffer.remaining(), this.readRemaining);
        byte[] bytes = new byte[toRead];
        buffer.get(bytes, 0, toRead);
        this.listener.onBodyReceived(bytes, toRead);
        if (nextState != null) {
            this.readRemaining -= toRead;
            if (this.readRemaining == 0) {
                this.state = nextState;
            }
        }
    }

    void readEmptyLine(ByteBuffer buffer) {
        byte b = buffer.get();
        if (b == 13 && buffer.hasRemaining()) {
            buffer.get();
        }
    }

    private void readHeaders(ByteBuffer buffer) throws LineTooLargeException, AbortException {
        String line = this.lineReader.readLine(buffer);
        while (line != null && !line.isEmpty()) {
            HttpUtils.splitAndAddHeader(line, this.headers);
            line = this.lineReader.readLine(buffer);
        }
        if (line == null) {
            return;
        }
        this.listener.onHeadersReceived(this.headers);
        if (this.method == HttpMethod.HEAD) {
            this.state = State.ALL_READ;
            return;
        }
        String te = this.headers.get("transfer-encoding");
        if ("chunked".equals(te)) {
            this.state = State.READ_CHUNK_SIZE;
        } else {
            String cl = this.headers.get("content-length");
            if (cl != null) {
                this.readRemaining = Integer.parseInt(cl);
                this.state = this.readRemaining == 0 ? State.ALL_READ : State.READ_FIXED_LENGTH_CONTENT;
            } else if (this.emptyBodyExpected) {
                this.state = State.ALL_READ;
            } else {
                this.state = State.READ_VARIABLE_LENGTH_CONTENT;
                this.readRemaining = Integer.MAX_VALUE;
            }
        }
    }
}

