/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.httpkit.client.HttpClient;
import org.httpkit.client.IFilter;
import org.httpkit.client.RequestConfig;
import org.httpkit.client.RespListener;
import org.httpkit.client.ResponseHandler;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class HttpClientTest {
    HttpClient client;
    Map<String, Object> emptyHeader;
    CountDownLatch cd;
    Proxy socksProxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress("127.0.0.1", 3128));
    private RespListener listener;

    public HttpClientTest() throws IOException {
        String userAgent = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.19 Safari/537.31";
        this.client = new HttpClient();
    }

    @Before
    public void setup() throws IOException {
        this.cd = new CountDownLatch(1);
        this.listener = new RespListener(new ResponseHandler(this.cd), IFilter.ACCEPT_ALL, Executors.newCachedThreadPool(), 0);
    }

    @After
    public void tearDown() throws InterruptedException {
        Assert.assertTrue((boolean)this.cd.await(4000L, TimeUnit.SECONDS));
    }

    public void get(String url) throws URISyntaxException {
        this.client.exec(url, new RequestConfig(), null, this.listener);
    }

    @Test
    public void testGetpythonServer() throws UnknownHostException, URISyntaxException, InterruptedException {
        this.get("http://wiki.nginx.org/Main");
    }

    public static void main(String[] args) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore ks = KeyStore.getInstance("JKS");
        char[] passphrase = "123456".toCharArray();
        ks.load(new FileInputStream("/tmp/testkeys"), passphrase);
    }

    @Test
    public void testHttpS() throws URISyntaxException, InterruptedException {
        this.get("https://github.com/http-kit/http-kit");
        this.cd.await();
        this.get("https://github.com/shenfeng/FrameworkBenchmarks");
    }

    @Test
    public void testSocksProxy() throws UnknownHostException, URISyntaxException, InterruptedException {
        this.get("http://feeds2.feedburner.com/dwahlin");
    }

    @Test
    public void testGetGzipped() throws UnknownHostException, URISyntaxException, InterruptedException {
        this.get("http://en.wikipedia.org/wiki/HTTP");
    }

    @Test
    public void testDecodeSinaGzipped() throws UnknownHostException, URISyntaxException, InterruptedException {
        this.get("http://www.sina.com.cn/");
    }

    @Test
    public void testAprotocolException() throws UnknownHostException, URISyntaxException, InterruptedException {
        this.get("http://weblogs.asp.net/scottgu/rss.aspx");
    }

    @Test
    public void testDecodeNoLength() throws UnknownHostException, URISyntaxException, InterruptedException {
        this.get("http://127.0.0.1:8089");
    }

    @Test
    public void testProtocolException() throws UnknownHostException, URISyntaxException, InterruptedException {
        this.get("http://127.0.0.1:8089");
    }
}

