/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NBlockingSSL {
    private static Logger logger = LoggerFactory.getLogger(NBlockingSSL.class);
    private static final SSLContext CLIENT_CONTEXT;
    private static Selector selector;
    public static SSLEngine engine;
    private static boolean isHandshakeDone;
    private static SelectionKey key;
    private static ByteBuffer myNetData;
    private static ByteBuffer peerNetData;
    private static ByteBuffer peerAppData;
    private static SocketChannel socketChannel;
    private static final String HOST = "github.com";

    public static void main(String[] args) throws IOException {
        engine = CLIENT_CONTEXT.createSSLEngine();
        engine.setUseClientMode(true);
        selector = Selector.open();
        socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        key = socketChannel.register(selector, 8);
        socketChannel.connect(new InetSocketAddress(HOST, 443));
        int i = 0;
        block0: while (true) {
            int select;
            if ((select = selector.select(1000L)) > 0) {
                Set<SelectionKey> selectionKeys = selector.selectedKeys();
                Iterator<SelectionKey> ite = selectionKeys.iterator();
                while (true) {
                    SSLEngineResult res;
                    if (!ite.hasNext()) continue block0;
                    SelectionKey key = ite.next();
                    if (key.isConnectable()) {
                        if (socketChannel.finishConnect()) {
                            key.interestOps(4);
                            engine.beginHandshake();
                        }
                    } else if (key.isReadable()) {
                        if (!isHandshakeDone) {
                            NBlockingSSL.doHandshake();
                        } else {
                            int read = socketChannel.read(peerNetData);
                            if (read > 0) {
                                peerNetData.flip();
                                res = engine.unwrap(peerNetData, peerAppData);
                                if (res.getStatus() == SSLEngineResult.Status.OK) {
                                    peerAppData.flip();
                                    byte[] data = new byte[peerAppData.remaining()];
                                    peerAppData.get(data);
                                    ++i;
                                    logger.info("get data length: " + new String(data).length());
                                    key.interestOps(4);
                                    peerAppData.clear();
                                    if (i > 5) {
                                        return;
                                    }
                                }
                                logger.info("read unwrap, " + res);
                                peerNetData.compact();
                            }
                        }
                    } else if (key.isWritable()) {
                        if (!isHandshakeDone) {
                            NBlockingSSL.doHandshake();
                        } else {
                            myNetData.clear();
                            ByteBuffer buffer = ByteBuffer.wrap("GET / HTTP/1.1\r\nHost: github.com\r\n\r\n".getBytes());
                            res = engine.wrap(buffer, myNetData);
                            if (res.getStatus() == SSLEngineResult.Status.OK) {
                                myNetData.flip();
                                socketChannel.write(myNetData);
                                if (!myNetData.hasRemaining()) {
                                    key.interestOps(1);
                                }
                            }
                        }
                    }
                    ite.remove();
                }
            }
            logger.info("waiting");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void doHandshake() throws IOException {
        SSLEngineResult.HandshakeStatus hs = engine.getHandshakeStatus();
        isHandshakeDone = hs == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || hs == SSLEngineResult.HandshakeStatus.FINISHED;
        while (!isHandshakeDone) {
            switch (hs) {
                case NEED_TASK: {
                    Runnable runnable;
                    while ((runnable = engine.getDelegatedTask()) != null) {
                        logger.info("get task " + runnable);
                        runnable.run();
                    }
                    break;
                }
                case NEED_UNWRAP: {
                    int read = socketChannel.read(peerNetData);
                    logger.info("read {} bytes", (Object)read);
                    if (read < 0) {
                        logger.info("closed");
                        break;
                    }
                    peerNetData.flip();
                    SSLEngineResult res = engine.unwrap(peerNetData, peerAppData);
                    logger.info("hs unwrap, " + res);
                    if (res.getStatus() != SSLEngineResult.Status.OK) {
                        System.out.println("--------------------------");
                    }
                    peerNetData.compact();
                    switch (res.getStatus()) {
                        case OK: {
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            logger.info("waiting for more info");
                            return;
                        }
                        case BUFFER_OVERFLOW: {
                            break;
                        }
                    }
                    if (engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
                    key.interestOps(4);
                    logger.info("for write");
                    return;
                }
                case NEED_WRAP: {
                    SSLEngineResult result = engine.wrap(ByteBuffer.allocate(0), myNetData);
                    logger.info("wrap: " + result);
                    myNetData.flip();
                    socketChannel.write(myNetData);
                    if (engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        // empty if block
                    }
                    if (!myNetData.hasRemaining()) {
                        if ((key.interestOps() & 1) == 0) {
                            key.interestOps(1);
                            logger.info("for read");
                        }
                        myNetData.clear();
                        break;
                    }
                    myNetData.compact();
                }
            }
            hs = engine.getHandshakeStatus();
            isHandshakeDone = hs == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || hs == SSLEngineResult.HandshakeStatus.FINISHED;
            if (!isHandshakeDone) continue;
            logger.info("handshake done");
            peerNetData.clear();
            ByteBuffer buffer = ByteBuffer.wrap("GET / HTTP/1.1\r\nHost: github.com\r\n\r\n".getBytes());
            SSLEngineResult res = engine.wrap(buffer, myNetData);
            RandomAccessFile r = new RandomAccessFile("/home/feng/workspace/http-kit/blog.access.log", "r");
            MappedByteBuffer b = r.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, r.getChannel().size());
            ByteBuffer bf = ByteBuffer.allocate(262144);
            SSLEngineResult t = engine.wrap(b, bf);
            System.out.println(t);
            if (res.getStatus() != SSLEngineResult.Status.OK) continue;
            myNetData.flip();
            socketChannel.write(myNetData);
            if (!myNetData.hasRemaining()) continue;
            key.interestOps(4);
        }
    }

    static {
        try {
            CLIENT_CONTEXT = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("Failed to initialize the client-side SSLContext", e);
        }
        isHandshakeDone = false;
        myNetData = ByteBuffer.allocate(32768);
        peerNetData = ByteBuffer.allocate(24576);
        peerAppData = ByteBuffer.allocate(24576);
    }
}

