/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;

public class SSLTest {
    private static final SSLContext CLIENT_CONTEXT;

    public static void main(String[] args) throws Exception {
        int read;
        SSLEngine engine = CLIENT_CONTEXT.createSSLEngine();
        engine.setUseClientMode(true);
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(true);
        socketChannel.connect(new InetSocketAddress("google.com", 443));
        while (!socketChannel.finishConnect()) {
            Thread.sleep(50L);
        }
        SSLSession session = engine.getSession();
        ByteBuffer myNetData = ByteBuffer.allocate(session.getPacketBufferSize());
        ByteBuffer peerAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
        ByteBuffer peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
        peerNetData.limit(0);
        ByteBuffer myAppData = ByteBuffer.wrap("GET / HTTP/1.1\r\nHost: \r\n\r\n".getBytes());
        engine.beginHandshake();
        SSLEngineResult.HandshakeStatus hs = engine.getHandshakeStatus();
        while (hs != SSLEngineResult.HandshakeStatus.FINISHED && hs != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            System.out.println("hs status: " + (Object)((Object)hs));
            switch (hs) {
                case NEED_TASK: {
                    Runnable runnable;
                    while ((runnable = engine.getDelegatedTask()) != null) {
                        System.out.println("get task " + runnable);
                        runnable.run();
                    }
                    break;
                }
                case NEED_UNWRAP: {
                    if (!peerNetData.hasRemaining()) {
                        peerNetData.clear();
                        int read2 = socketChannel.read(peerNetData);
                        System.out.println("read: " + read2 + "\t" + peerNetData);
                        peerNetData.flip();
                    }
                    SSLEngineResult status = engine.unwrap(peerNetData, peerAppData);
                    System.out.println("unwrap: " + status);
                    switch (status.getStatus()) {
                        case BUFFER_UNDERFLOW: {
                            peerNetData.compact();
                            read = socketChannel.read(peerNetData);
                            System.out.println("flip read: " + read + "\t" + peerNetData);
                            peerNetData.flip();
                        }
                    }
                    break;
                }
                case NEED_WRAP: {
                    myNetData.clear();
                    SSLEngineResult wrapStatus = engine.wrap(myAppData, myNetData);
                    System.out.println("wrap: " + wrapStatus);
                    myNetData.flip();
                    while (myNetData.hasRemaining()) {
                        socketChannel.write(myNetData);
                    }
                    break;
                }
            }
            hs = engine.getHandshakeStatus();
        }
        for (int i = 0; i < 5; ++i) {
            myNetData.clear();
            peerAppData.clear();
            myAppData = ByteBuffer.wrap("GET / HTTP/1.1\r\nHost: www.google.co.jp\r\n\r\n".getBytes());
            SSLEngineResult wrapStatus = engine.wrap(myAppData, myNetData);
            myNetData.flip();
            while (myNetData.hasRemaining()) {
                socketChannel.write(myNetData);
            }
            peerNetData.clear();
            read = socketChannel.read(peerNetData);
            peerNetData.flip();
            SSLEngineResult status = engine.unwrap(peerNetData, peerAppData);
            while (status.getStatus() != SSLEngineResult.Status.OK) {
                peerNetData.compact();
                read = socketChannel.read(peerNetData);
                System.out.println("-------read: " + read + "\t" + peerNetData);
                peerNetData.flip();
                status = engine.unwrap(peerNetData, peerAppData);
            }
            peerAppData.flip();
            System.out.println(peerAppData);
            byte[] data = new byte[peerAppData.remaining()];
            peerAppData.get(data);
            System.out.println(new String(data));
        }
    }

    static {
        SSLContext clientContext = null;
        try {
            clientContext = SSLContext.getDefault();
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the client-side SSLContext", e);
        }
        CLIENT_CONTEXT = clientContext;
    }
}

