/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.httpkit.HttpMethod;
import org.httpkit.client.HttpClient;
import org.httpkit.client.IFilter;
import org.httpkit.client.IResponseHandler;
import org.httpkit.client.RequestConfig;
import org.httpkit.client.RespListener;
import org.junit.Before;
import org.junit.Test;

public class TextClientTest {
    HttpClient client;

    @Before
    public void setup() throws IOException {
        this.client = new HttpClient();
    }

    @Test
    public void testAbort() throws UnknownHostException, URISyntaxException, InterruptedException {
        String[] urls = new String[]{"http://cdn-smooth.ms-studiosmedia.com/news/mp4_mq/06182012_Surface_750k.mp4"};
        this.runIt(urls);
    }

    @Test
    public void testDecode() throws IOException, URISyntaxException, InterruptedException {
        String[] urls = new String[]{"http://feed.feedsky.com/amaze", "http://macorz.cn/feed", "http://www.ourlinux.net/feed", "http://blog.jjgod.org/feed/", "http://www.lostleon.com/blog/feed/", "http://feed.feedsky.com/hellodb"};
        this.runIt(urls);
    }

    public static void main(String[] args) {
        System.out.println((Object)HttpMethod.valueOf("GET1"));
    }

    private void runIt(String[] urls) throws URISyntaxException, UnknownHostException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(urls.length);
        ExecutorService pool = Executors.newCachedThreadPool();
        for (String url : urls) {
            IResponseHandler handler = new IResponseHandler(){

                @Override
                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                }

                @Override
                public void onSuccess(int status, Map<String, String> headers, Object body) {
                    System.out.println(body);
                }
            };
            this.client.exec(url, new RequestConfig(), null, new RespListener(handler, IFilter.ACCEPT_ALL, pool, 1));
        }
        latch.await();
    }
}

