/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;

public class ThreadPool {
    private final Worker[] workers;
    private final BlockingQueue<Runnable> queue;
    private volatile boolean closed = false;
    private final CountDownLatch latch;

    public ThreadPool(int size, BlockingQueue<Runnable> queue) {
        this.workers = new Worker[size];
        this.queue = queue;
        this.latch = new CountDownLatch(size);
        for (int i = 0; i < size; ++i) {
            this.workers[i] = new Worker(queue);
            this.workers[i].t.start();
        }
    }

    public void submit(Runnable task) {
        this.queue.offer(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coseAndwait() throws InterruptedException {
        this.closed = true;
        for (Worker w : this.workers) {
            w.t.interrupt();
        }
        CountDownLatch countDownLatch = this.latch;
        synchronized (countDownLatch) {
            if (this.latch.getCount() == 0L) {
                return;
            }
            return;
        }
    }

    class Worker
    implements Runnable {
        final BlockingQueue<Runnable> queue;
        final Thread t;

        public Worker(BlockingQueue<Runnable> queue) {
            this.queue = queue;
            this.t = new Thread(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    block6: while (true) {
                        if (this.queue.size() == 0 && ThreadPool.this.closed) {
                            CountDownLatch countDownLatch = ThreadPool.this.latch;
                            synchronized (countDownLatch) {
                                ThreadPool.this.latch.notify();
                            }
                            ThreadPool.this.latch.countDown();
                            return;
                        }
                        while (true) {
                            Runnable r;
                            if ((r = this.queue.take()) == null) continue block6;
                            r.run();
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

