(ns leiningen.new.steve
  (:require [leiningen.new.templates :refer [renderer name-to-path sanitize-ns ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "steve"))

(def dependencies
  {"om" '[[org.clojure/core.async "0.1.267.0-0d7780-alpha"]
          [om "0.7.1"]]})

(def with
  {"om" "http://fb.me/react-0.11.1.js"})

(defn includes [{:strs [with]}]
  {:dependencies (map #(hash-map :dep %) (dependencies with))})

(defn sources [{:keys [sanitized file-name] optimization-level "optimizations"} & includes]
  (let [cljs-src
        (cond->
         [{:src file-name}]
         (= optimization-level "none") (conj {:js (str "goog.require('" sanitized ".core');")})
         :truthy list*
         (= optimization-level "none") (conj {:src "out/goog/base.js"}))]
    (reduce
     (fn [sources src]
       (conj sources {:src src}))
     cljs-src
     includes)))

(defn scripts [{includes "with" :as args}]
  {:scripts (vec (sources args (with includes)))})

(defn compiler-options [optimization-level name]
  (merge {:output-to name
          :output-dir "out"
          :optimizations (keyword optimization-level)}
         (case optimization-level
           "none" {:source-map true}
           {:source-map (str name ".map")})))

(defn compiler [{name :file-name :strs [optimizations]}]
  {:compiler (compiler-options optimizations name)})

(defn cljs-file [{dep "with"}]
  (case dep
    "om" "om.cljs"
    "core.cljs"))

(defn steve
  [name & args]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}
        data (merge data
                    {"optimizations" "none" :file-name (str (:sanitized data) ".js")}
                    (apply hash-map args))
        options (merge data
                       (compiler data)
                       (scripts data)
                       (includes data))]
    (main/info (str "Generating fresh 'lein new' steve/austin project"))
    (->files data
             ["project.clj" (render "project.clj" options)]
             ["src/clj/auto_start.clj" (render "user.clj" options)]
             ["src/cljs/{{sanitized}}/core.cljs" (render (cljs-file options) options)])))
