(defproject stock-grok/util.messaging "1.2.0"
  :description "FIXME: write description"
  :url "https://github.com//"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}

  :dependencies [[fundingcircle/jackdaw "0.6.9"]
                 [com.taoensso/nippy "2.14.0"]
                 [org.clojure/core.async "0.4.490"]]

  :plugins [[lein-cloverage "1.0.13"]
            [lein-shell "0.5.0"]
            [lein-ancient "0.6.15"]
            [lein-changelog "0.3.2"]
            [nicheware/lein-gitlab-wagon "1.0.0"]]

  :profiles {:dev {:dependencies [[org.clojure/clojure "1.10.1"]]}}

  :repositories 
  {"private" {:url "gitlab://gitlab.com/api/v4/projects/14205575/packages/maven"
              :username "Job-Token"
              :password :env/ci_job_token
              :sign-releases false}}

  :deploy-repositories
  [["snapshot" {:url   "https://artifactory.cirill.io/artifactory/libs-snapshot-local/"
                :creds :gpg}]
   ["release" {:url "https://artifactory.cirill.io/artifactory/libs-release-local/"
               :creds :gpg}]]

  :aliases {"update-readme-version" ["shell" "sed" "-i" "s/\\\\[stock-grok\\.util\\.messaging \"[0-9.]*\"\\\\]/[stock-grok\\.util\\.messaging \"${:version}\"]/" "README.md"]}

  :release-tasks [["shell" "git" "diff" "--exit-code"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["changelog" "release"]
                  ["update-readme-version"]
                  ["vcs" "commit"]
                  ["vcs" "tag"]
                  ["deploy" "release"]
                  ["vcs" "push"]])
